/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.UsageName;
import com.azure.resourcemanager.network.models.UsageUnit;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class UsageInner {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="unit", required=true)
    private UsageUnit unit;
    @JsonProperty(value="currentValue", required=true)
    private long currentValue;
    @JsonProperty(value="limit", required=true)
    private long limit;
    @JsonProperty(value="name", required=true)
    private UsageName name;
    private static final ClientLogger LOGGER = new ClientLogger(UsageInner.class);

    public String id() {
        return this.id;
    }

    public UsageUnit unit() {
        return this.unit;
    }

    public UsageInner withUnit(UsageUnit unit) {
        this.unit = unit;
        return this;
    }

    public long currentValue() {
        return this.currentValue;
    }

    public UsageInner withCurrentValue(long currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public long limit() {
        return this.limit;
    }

    public UsageInner withLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public UsageName name() {
        return this.name;
    }

    public UsageInner withName(UsageName name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.unit() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property unit in model UsageInner"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model UsageInner"));
        }
        this.name().validate();
    }
}

