// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Represents a single NIC configuration properties.
 */
@Fluent
public final class VirtualApplianceNetworkInterfaceConfigurationProperties {
    /*
     * The ipConfigurations property.
     */
    @JsonProperty(value = "ipConfigurations")
    private List<VirtualApplianceIpConfiguration> ipConfigurations;

    /**
     * Creates an instance of VirtualApplianceNetworkInterfaceConfigurationProperties class.
     */
    public VirtualApplianceNetworkInterfaceConfigurationProperties() {
    }

    /**
     * Get the ipConfigurations property: The ipConfigurations property.
     * 
     * @return the ipConfigurations value.
     */
    public List<VirtualApplianceIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    /**
     * Set the ipConfigurations property: The ipConfigurations property.
     * 
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the VirtualApplianceNetworkInterfaceConfigurationProperties object itself.
     */
    public VirtualApplianceNetworkInterfaceConfigurationProperties
        withIpConfigurations(List<VirtualApplianceIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipConfigurations() != null) {
            ipConfigurations().forEach(e -> e.validate());
        }
    }
}
