// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The storage location for a packet capture session.
 */
@Fluent
public final class PacketCaptureSettings {
    /*
     * Number of file count. Default value of count is 10 and maximum number is 10000.
     */
    @JsonProperty(value = "fileCount")
    private Integer fileCount;

    /*
     * Number of bytes captured per packet. Default value in bytes 104857600 (100MB) and maximum in bytes 4294967295 (4GB).
     */
    @JsonProperty(value = "fileSizeInBytes")
    private Long fileSizeInBytes;

    /*
     * Maximum duration of the capture session in seconds is 604800s (7 days) for a file. Default value in second 86400s (1 day).
     */
    @JsonProperty(value = "sessionTimeLimitInSeconds")
    private Integer sessionTimeLimitInSeconds;

    /**
     * Creates an instance of PacketCaptureSettings class.
     */
    public PacketCaptureSettings() {
    }

    /**
     * Get the fileCount property: Number of file count. Default value of count is 10 and maximum number is 10000.
     * 
     * @return the fileCount value.
     */
    public Integer fileCount() {
        return this.fileCount;
    }

    /**
     * Set the fileCount property: Number of file count. Default value of count is 10 and maximum number is 10000.
     * 
     * @param fileCount the fileCount value to set.
     * @return the PacketCaptureSettings object itself.
     */
    public PacketCaptureSettings withFileCount(Integer fileCount) {
        this.fileCount = fileCount;
        return this;
    }

    /**
     * Get the fileSizeInBytes property: Number of bytes captured per packet. Default value in bytes 104857600 (100MB)
     * and maximum in bytes 4294967295 (4GB).
     * 
     * @return the fileSizeInBytes value.
     */
    public Long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    /**
     * Set the fileSizeInBytes property: Number of bytes captured per packet. Default value in bytes 104857600 (100MB)
     * and maximum in bytes 4294967295 (4GB).
     * 
     * @param fileSizeInBytes the fileSizeInBytes value to set.
     * @return the PacketCaptureSettings object itself.
     */
    public PacketCaptureSettings withFileSizeInBytes(Long fileSizeInBytes) {
        this.fileSizeInBytes = fileSizeInBytes;
        return this;
    }

    /**
     * Get the sessionTimeLimitInSeconds property: Maximum duration of the capture session in seconds is 604800s (7
     * days) for a file. Default value in second 86400s (1 day).
     * 
     * @return the sessionTimeLimitInSeconds value.
     */
    public Integer sessionTimeLimitInSeconds() {
        return this.sessionTimeLimitInSeconds;
    }

    /**
     * Set the sessionTimeLimitInSeconds property: Maximum duration of the capture session in seconds is 604800s (7
     * days) for a file. Default value in second 86400s (1 day).
     * 
     * @param sessionTimeLimitInSeconds the sessionTimeLimitInSeconds value to set.
     * @return the PacketCaptureSettings object itself.
     */
    public PacketCaptureSettings withSessionTimeLimitInSeconds(Integer sessionTimeLimitInSeconds) {
        this.sessionTimeLimitInSeconds = sessionTimeLimitInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
