// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An optional field under "Rewrite Action". It lets you capture and modify the value(s) of a specific header when
 * multiple headers with the same name exist. Currently supported for Set-Cookie Response header only. For more details,
 * visit https://aka.ms/appgwheadercrud.
 */
@Fluent
public final class HeaderValueMatcher {
    /*
     * The pattern, either fixed string or regular expression, that evaluates if a header value should be selected for rewrite.
     */
    @JsonProperty(value = "pattern")
    private String pattern;

    /*
     * Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
     */
    @JsonProperty(value = "ignoreCase")
    private Boolean ignoreCase;

    /*
     * Setting this value as truth will force to check the negation of the condition given by the user in the pattern field.
     */
    @JsonProperty(value = "negate")
    private Boolean negate;

    /**
     * Creates an instance of HeaderValueMatcher class.
     */
    public HeaderValueMatcher() {
    }

    /**
     * Get the pattern property: The pattern, either fixed string or regular expression, that evaluates if a header
     * value should be selected for rewrite.
     * 
     * @return the pattern value.
     */
    public String pattern() {
        return this.pattern;
    }

    /**
     * Set the pattern property: The pattern, either fixed string or regular expression, that evaluates if a header
     * value should be selected for rewrite.
     * 
     * @param pattern the pattern value to set.
     * @return the HeaderValueMatcher object itself.
     */
    public HeaderValueMatcher withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    /**
     * Get the ignoreCase property: Setting this parameter to truth value with force the pattern to do a case
     * in-sensitive comparison.
     * 
     * @return the ignoreCase value.
     */
    public Boolean ignoreCase() {
        return this.ignoreCase;
    }

    /**
     * Set the ignoreCase property: Setting this parameter to truth value with force the pattern to do a case
     * in-sensitive comparison.
     * 
     * @param ignoreCase the ignoreCase value to set.
     * @return the HeaderValueMatcher object itself.
     */
    public HeaderValueMatcher withIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    /**
     * Get the negate property: Setting this value as truth will force to check the negation of the condition given by
     * the user in the pattern field.
     * 
     * @return the negate value.
     */
    public Boolean negate() {
        return this.negate;
    }

    /**
     * Set the negate property: Setting this value as truth will force to check the negation of the condition given by
     * the user in the pattern field.
     * 
     * @param negate the negate value to set.
     * @return the HeaderValueMatcher object itself.
     */
    public HeaderValueMatcher withNegate(Boolean negate) {
        this.negate = negate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
