// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Configuration for intrusion detection mode and rules.
 */
@Fluent
public final class FirewallPolicyIntrusionDetection {
    /*
     * Intrusion detection general state. When attached to a parent policy, the firewall's effective IDPS mode is the stricter mode of the two.
     */
    @JsonProperty(value = "mode")
    private FirewallPolicyIntrusionDetectionStateType mode;

    /*
     * IDPS profile name. When attached to a parent policy, the firewall's effective profile is the profile name of the parent policy.
     */
    @JsonProperty(value = "profile")
    private FirewallPolicyIntrusionDetectionProfileType profile;

    /*
     * Intrusion detection configuration properties.
     */
    @JsonProperty(value = "configuration")
    private FirewallPolicyIntrusionDetectionConfiguration configuration;

    /**
     * Creates an instance of FirewallPolicyIntrusionDetection class.
     */
    public FirewallPolicyIntrusionDetection() {
    }

    /**
     * Get the mode property: Intrusion detection general state. When attached to a parent policy, the firewall's
     * effective IDPS mode is the stricter mode of the two.
     * 
     * @return the mode value.
     */
    public FirewallPolicyIntrusionDetectionStateType mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Intrusion detection general state. When attached to a parent policy, the firewall's
     * effective IDPS mode is the stricter mode of the two.
     * 
     * @param mode the mode value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection withMode(FirewallPolicyIntrusionDetectionStateType mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the profile property: IDPS profile name. When attached to a parent policy, the firewall's effective profile
     * is the profile name of the parent policy.
     * 
     * @return the profile value.
     */
    public FirewallPolicyIntrusionDetectionProfileType profile() {
        return this.profile;
    }

    /**
     * Set the profile property: IDPS profile name. When attached to a parent policy, the firewall's effective profile
     * is the profile name of the parent policy.
     * 
     * @param profile the profile value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection withProfile(FirewallPolicyIntrusionDetectionProfileType profile) {
        this.profile = profile;
        return this;
    }

    /**
     * Get the configuration property: Intrusion detection configuration properties.
     * 
     * @return the configuration value.
     */
    public FirewallPolicyIntrusionDetectionConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Intrusion detection configuration properties.
     * 
     * @param configuration the configuration value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection
        withConfiguration(FirewallPolicyIntrusionDetectionConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
    }
}
