// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.ExpressRoutePortAuthorizationsClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRoutePortAuthorizationInner;
import com.azure.resourcemanager.network.models.ExpressRoutePortAuthorizationListResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.nio.ByteBuffer;

/**
 * An instance of this class provides access to all the operations defined in ExpressRoutePortAuthorizationsClient.
 */
public final class ExpressRoutePortAuthorizationsClientImpl implements ExpressRoutePortAuthorizationsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ExpressRoutePortAuthorizationsService service;

    /**
     * The service client containing this operation class.
     */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of ExpressRoutePortAuthorizationsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ExpressRoutePortAuthorizationsClientImpl(NetworkManagementClientImpl client) {
        this.service = RestProxy.create(ExpressRoutePortAuthorizationsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientExpressRoutePortAuthorizations to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementCli")
    public interface ExpressRoutePortAuthorizationsService {
        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRoutePorts/{expressRoutePortName}/authorizations/{authorizationName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("expressRoutePortName") String expressRoutePortName,
            @PathParam("authorizationName") String authorizationName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRoutePorts/{expressRoutePortName}/authorizations/{authorizationName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRoutePortAuthorizationInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("expressRoutePortName") String expressRoutePortName,
            @PathParam("authorizationName") String authorizationName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRoutePorts/{expressRoutePortName}/authorizations/{authorizationName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("expressRoutePortName") String expressRoutePortName,
            @PathParam("authorizationName") String authorizationName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ExpressRoutePortAuthorizationInner authorizationParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRoutePorts/{expressRoutePortName}/authorizations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRoutePortAuthorizationListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("expressRoutePortName") String expressRoutePortName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ExpressRoutePortAuthorizationListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (authorizationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, expressRoutePortName,
                authorizationName, apiVersion, this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (authorizationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, expressRoutePortName, authorizationName,
            apiVersion, this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String expressRoutePortName,
        String authorizationName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, expressRoutePortName, authorizationName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String expressRoutePortName,
        String authorizationName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, expressRoutePortName, authorizationName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String expressRoutePortName,
        String authorizationName) {
        return this.beginDeleteAsync(resourceGroupName, expressRoutePortName, authorizationName).getSyncPoller();
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String expressRoutePortName,
        String authorizationName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, expressRoutePortName, authorizationName, context)
            .getSyncPoller();
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String expressRoutePortName, String authorizationName) {
        return beginDeleteAsync(resourceGroupName, expressRoutePortName, authorizationName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String expressRoutePortName, String authorizationName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, expressRoutePortName, authorizationName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String expressRoutePortName, String authorizationName) {
        deleteAsync(resourceGroupName, expressRoutePortName, authorizationName).block();
    }

    /**
     * Deletes the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String expressRoutePortName, String authorizationName,
        Context context) {
        deleteAsync(resourceGroupName, expressRoutePortName, authorizationName, context).block();
    }

    /**
     * Gets the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified authorization from the specified express route port along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ExpressRoutePortAuthorizationInner>> getWithResponseAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (authorizationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, expressRoutePortName,
                authorizationName, apiVersion, this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified authorization from the specified express route port along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ExpressRoutePortAuthorizationInner>> getWithResponseAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (authorizationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, expressRoutePortName, authorizationName,
            apiVersion, this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Gets the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified authorization from the specified express route port on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRoutePortAuthorizationInner> getAsync(String resourceGroupName, String expressRoutePortName,
        String authorizationName) {
        return getWithResponseAsync(resourceGroupName, expressRoutePortName, authorizationName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified authorization from the specified express route port along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ExpressRoutePortAuthorizationInner> getWithResponse(String resourceGroupName,
        String expressRoutePortName, String authorizationName, Context context) {
        return getWithResponseAsync(resourceGroupName, expressRoutePortName, authorizationName, context).block();
    }

    /**
     * Gets the specified authorization from the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified authorization from the specified express route port.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRoutePortAuthorizationInner get(String resourceGroupName, String expressRoutePortName,
        String authorizationName) {
        return getWithResponse(resourceGroupName, expressRoutePortName, authorizationName, Context.NONE).getValue();
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName,
        ExpressRoutePortAuthorizationInner authorizationParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (authorizationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (authorizationParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationParameters is required and cannot be null."));
        } else {
            authorizationParameters.validate();
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName,
                expressRoutePortName, authorizationName, apiVersion, this.client.getSubscriptionId(),
                authorizationParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName,
        ExpressRoutePortAuthorizationInner authorizationParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (authorizationName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (authorizationParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationParameters is required and cannot be null."));
        } else {
            authorizationParameters.validate();
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, expressRoutePortName,
            authorizationName, apiVersion, this.client.getSubscriptionId(), authorizationParameters, accept, context);
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of expressRoute Port Authorization.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ExpressRoutePortAuthorizationInner>, ExpressRoutePortAuthorizationInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String expressRoutePortName, String authorizationName,
            ExpressRoutePortAuthorizationInner authorizationParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, expressRoutePortName,
            authorizationName, authorizationParameters);
        return this.client.<ExpressRoutePortAuthorizationInner, ExpressRoutePortAuthorizationInner>getLroResult(mono,
            this.client.getHttpPipeline(), ExpressRoutePortAuthorizationInner.class,
            ExpressRoutePortAuthorizationInner.class, this.client.getContext());
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of expressRoute Port Authorization.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExpressRoutePortAuthorizationInner>, ExpressRoutePortAuthorizationInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String expressRoutePortName, String authorizationName,
            ExpressRoutePortAuthorizationInner authorizationParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, expressRoutePortName,
            authorizationName, authorizationParameters, context);
        return this.client.<ExpressRoutePortAuthorizationInner, ExpressRoutePortAuthorizationInner>getLroResult(mono,
            this.client.getHttpPipeline(), ExpressRoutePortAuthorizationInner.class,
            ExpressRoutePortAuthorizationInner.class, context);
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of expressRoute Port Authorization.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExpressRoutePortAuthorizationInner>, ExpressRoutePortAuthorizationInner>
        beginCreateOrUpdate(String resourceGroupName, String expressRoutePortName, String authorizationName,
            ExpressRoutePortAuthorizationInner authorizationParameters) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, expressRoutePortName, authorizationName,
                authorizationParameters)
            .getSyncPoller();
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of expressRoute Port Authorization.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExpressRoutePortAuthorizationInner>, ExpressRoutePortAuthorizationInner>
        beginCreateOrUpdate(String resourceGroupName, String expressRoutePortName, String authorizationName,
            ExpressRoutePortAuthorizationInner authorizationParameters, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, expressRoutePortName, authorizationName,
                authorizationParameters, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ExpressRoutePortAuthorizationInner> createOrUpdateAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName,
        ExpressRoutePortAuthorizationInner authorizationParameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, expressRoutePortName, authorizationName,
            authorizationParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ExpressRoutePortAuthorizationInner> createOrUpdateAsync(String resourceGroupName,
        String expressRoutePortName, String authorizationName,
        ExpressRoutePortAuthorizationInner authorizationParameters, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, expressRoutePortName, authorizationName,
            authorizationParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRoutePortAuthorizationInner createOrUpdate(String resourceGroupName, String expressRoutePortName,
        String authorizationName, ExpressRoutePortAuthorizationInner authorizationParameters) {
        return createOrUpdateAsync(resourceGroupName, expressRoutePortName, authorizationName, authorizationParameters)
            .block();
    }

    /**
     * Creates or updates an authorization in the specified express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param authorizationName The name of the authorization.
     * @param authorizationParameters Parameters supplied to the create or update express route port authorization
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ExpressRoutePortAuthorizationInner createOrUpdate(String resourceGroupName, String expressRoutePortName,
        String authorizationName, ExpressRoutePortAuthorizationInner authorizationParameters, Context context) {
        return createOrUpdateAsync(resourceGroupName, expressRoutePortName, authorizationName, authorizationParameters,
            context).block();
    }

    /**
     * Gets all authorizations in an express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorizations in an express route port along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRoutePortAuthorizationInner>> listSinglePageAsync(String resourceGroupName,
        String expressRoutePortName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), resourceGroupName, expressRoutePortName,
                apiVersion, this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<ExpressRoutePortAuthorizationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all authorizations in an express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorizations in an express route port along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRoutePortAuthorizationInner>> listSinglePageAsync(String resourceGroupName,
        String expressRoutePortName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRoutePortName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter expressRoutePortName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-11-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), resourceGroupName, expressRoutePortName, apiVersion,
                this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets all authorizations in an express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorizations in an express route port as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ExpressRoutePortAuthorizationInner> listAsync(String resourceGroupName,
        String expressRoutePortName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, expressRoutePortName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all authorizations in an express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorizations in an express route port as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ExpressRoutePortAuthorizationInner> listAsync(String resourceGroupName,
        String expressRoutePortName, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, expressRoutePortName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all authorizations in an express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorizations in an express route port as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ExpressRoutePortAuthorizationInner> list(String resourceGroupName,
        String expressRoutePortName) {
        return new PagedIterable<>(listAsync(resourceGroupName, expressRoutePortName));
    }

    /**
     * Gets all authorizations in an express route port.
     *
     * @param resourceGroupName The name of the resource group.
     * @param expressRoutePortName The name of the express route port.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all authorizations in an express route port as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ExpressRoutePortAuthorizationInner> list(String resourceGroupName, String expressRoutePortName,
        Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, expressRoutePortName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization List Result along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRoutePortAuthorizationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ExpressRoutePortAuthorizationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return expressRoute Port Authorization List Result along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRoutePortAuthorizationInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
