// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.models.ContainerNetworkInterface;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Network profile resource.
 */
@Fluent
public final class NetworkProfileInner extends Resource {
    /*
     * Network profile properties.
     */
    @JsonProperty(value = "properties")
    private NetworkProfilePropertiesFormat innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Creates an instance of NetworkProfileInner class.
     */
    public NetworkProfileInner() {
    }

    /**
     * Get the innerProperties property: Network profile properties.
     * 
     * @return the innerProperties value.
     */
    private NetworkProfilePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the NetworkProfileInner object itself.
     */
    public NetworkProfileInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the containerNetworkInterfaces property: List of child container network interfaces.
     * 
     * @return the containerNetworkInterfaces value.
     */
    public List<ContainerNetworkInterface> containerNetworkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaces();
    }

    /**
     * Get the containerNetworkInterfaceConfigurations property: List of chid container network interface
     * configurations.
     * 
     * @return the containerNetworkInterfaceConfigurations value.
     */
    public List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaceConfigurations();
    }

    /**
     * Set the containerNetworkInterfaceConfigurations property: List of chid container network interface
     * configurations.
     * 
     * @param containerNetworkInterfaceConfigurations the containerNetworkInterfaceConfigurations value to set.
     * @return the NetworkProfileInner object itself.
     */
    public NetworkProfileInner withContainerNetworkInterfaceConfigurations(
        List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkProfilePropertiesFormat();
        }
        this.innerProperties().withContainerNetworkInterfaceConfigurations(containerNetworkInterfaceConfigurations);
        return this;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the network profile resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Get the provisioningState property: The provisioning state of the network profile resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
