// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.InboundSecurityRuleType;
import com.azure.resourcemanager.network.models.InboundSecurityRules;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Properties of the Inbound Security Rules resource.
 */
@Fluent
public final class InboundSecurityRuleProperties {
    /*
     * Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule.
     */
    @JsonProperty(value = "ruleType")
    private InboundSecurityRuleType ruleType;

    /*
     * List of allowed rules.
     */
    @JsonProperty(value = "rules")
    private List<InboundSecurityRules> rules;

    /*
     * The provisioning state of the resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of InboundSecurityRuleProperties class.
     */
    public InboundSecurityRuleProperties() {
    }

    /**
     * Get the ruleType property: Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only
     * creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule.
     *
     * @return the ruleType value.
     */
    public InboundSecurityRuleType ruleType() {
        return this.ruleType;
    }

    /**
     * Set the ruleType property: Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only
     * creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule.
     *
     * @param ruleType the ruleType value to set.
     * @return the InboundSecurityRuleProperties object itself.
     */
    public InboundSecurityRuleProperties withRuleType(InboundSecurityRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    /**
     * Get the rules property: List of allowed rules.
     *
     * @return the rules value.
     */
    public List<InboundSecurityRules> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of allowed rules.
     *
     * @param rules the rules value to set.
     * @return the InboundSecurityRuleProperties object itself.
     */
    public InboundSecurityRuleProperties withRules(List<InboundSecurityRules> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }
}
