// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRuleProtocol;
import com.azure.resourcemanager.network.models.AzureFirewallPacketCaptureFlags;
import com.azure.resourcemanager.network.models.AzureFirewallPacketCaptureRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Packet capture parameters on azure firewall.
 */
@Fluent
public final class FirewallPacketCaptureParametersFormat {
    /*
     * Duration of packet capture in seconds.
     */
    @JsonProperty(value = "durationInSeconds")
    private Integer durationInSeconds;

    /*
     * Number of packets to be captured.
     */
    @JsonProperty(value = "numberOfPacketsToCapture")
    private Integer numberOfPacketsToCapture;

    /*
     * Upload capture location
     */
    @JsonProperty(value = "sasUrl")
    private String sasUrl;

    /*
     * Name of file to be uploaded to sasURL
     */
    @JsonProperty(value = "fileName")
    private String fileName;

    /*
     * The protocol of packets to capture
     */
    @JsonProperty(value = "protocol")
    private AzureFirewallNetworkRuleProtocol protocol;

    /*
     * The tcp-flag type to be captured. Used with protocol TCP
     */
    @JsonProperty(value = "flags")
    private List<AzureFirewallPacketCaptureFlags> flags;

    /*
     * Rules to filter packet captures.
     */
    @JsonProperty(value = "filters")
    private List<AzureFirewallPacketCaptureRule> filters;

    /**
     * Creates an instance of FirewallPacketCaptureParametersFormat class.
     */
    public FirewallPacketCaptureParametersFormat() {
    }

    /**
     * Get the durationInSeconds property: Duration of packet capture in seconds.
     * 
     * @return the durationInSeconds value.
     */
    public Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    /**
     * Set the durationInSeconds property: Duration of packet capture in seconds.
     * 
     * @param durationInSeconds the durationInSeconds value to set.
     * @return the FirewallPacketCaptureParametersFormat object itself.
     */
    public FirewallPacketCaptureParametersFormat withDurationInSeconds(Integer durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    /**
     * Get the numberOfPacketsToCapture property: Number of packets to be captured.
     * 
     * @return the numberOfPacketsToCapture value.
     */
    public Integer numberOfPacketsToCapture() {
        return this.numberOfPacketsToCapture;
    }

    /**
     * Set the numberOfPacketsToCapture property: Number of packets to be captured.
     * 
     * @param numberOfPacketsToCapture the numberOfPacketsToCapture value to set.
     * @return the FirewallPacketCaptureParametersFormat object itself.
     */
    public FirewallPacketCaptureParametersFormat withNumberOfPacketsToCapture(Integer numberOfPacketsToCapture) {
        this.numberOfPacketsToCapture = numberOfPacketsToCapture;
        return this;
    }

    /**
     * Get the sasUrl property: Upload capture location.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: Upload capture location.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the FirewallPacketCaptureParametersFormat object itself.
     */
    public FirewallPacketCaptureParametersFormat withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get the fileName property: Name of file to be uploaded to sasURL.
     * 
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: Name of file to be uploaded to sasURL.
     * 
     * @param fileName the fileName value to set.
     * @return the FirewallPacketCaptureParametersFormat object itself.
     */
    public FirewallPacketCaptureParametersFormat withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the protocol property: The protocol of packets to capture.
     * 
     * @return the protocol value.
     */
    public AzureFirewallNetworkRuleProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol of packets to capture.
     * 
     * @param protocol the protocol value to set.
     * @return the FirewallPacketCaptureParametersFormat object itself.
     */
    public FirewallPacketCaptureParametersFormat withProtocol(AzureFirewallNetworkRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the flags property: The tcp-flag type to be captured. Used with protocol TCP.
     * 
     * @return the flags value.
     */
    public List<AzureFirewallPacketCaptureFlags> flags() {
        return this.flags;
    }

    /**
     * Set the flags property: The tcp-flag type to be captured. Used with protocol TCP.
     * 
     * @param flags the flags value to set.
     * @return the FirewallPacketCaptureParametersFormat object itself.
     */
    public FirewallPacketCaptureParametersFormat withFlags(List<AzureFirewallPacketCaptureFlags> flags) {
        this.flags = flags;
        return this;
    }

    /**
     * Get the filters property: Rules to filter packet captures.
     * 
     * @return the filters value.
     */
    public List<AzureFirewallPacketCaptureRule> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: Rules to filter packet captures.
     * 
     * @param filters the filters value to set.
     * @return the FirewallPacketCaptureParametersFormat object itself.
     */
    public FirewallPacketCaptureParametersFormat withFilters(List<AzureFirewallPacketCaptureRule> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (flags() != null) {
            flags().forEach(e -> e.validate());
        }
        if (filters() != null) {
            filters().forEach(e -> e.validate());
        }
    }
}
