// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.CommissionedState;
import com.azure.resourcemanager.network.models.CustomIpPrefixType;
import com.azure.resourcemanager.network.models.Geo;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Custom IP prefix properties.
 */
@Fluent
public final class CustomIpPrefixPropertiesFormat {
    /*
     * The ASN for CIDR advertising. Should be an integer as string.
     */
    @JsonProperty(value = "asn")
    private String asn;

    /*
     * The prefix range in CIDR notation. Should include the start address and the prefix length.
     */
    @JsonProperty(value = "cidr")
    private String cidr;

    /*
     * Signed message for WAN validation.
     */
    @JsonProperty(value = "signedMessage")
    private String signedMessage;

    /*
     * Authorization message for WAN validation.
     */
    @JsonProperty(value = "authorizationMessage")
    private String authorizationMessage;

    /*
     * The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     */
    @JsonProperty(value = "customIpPrefixParent")
    private SubResource customIpPrefixParent;

    /*
     * The list of all Children for IPv6 /48 CustomIpPrefix.
     */
    @JsonProperty(value = "childCustomIpPrefixes", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> childCustomIpPrefixes;

    /*
     * The commissioned state of the Custom IP Prefix.
     */
    @JsonProperty(value = "commissionedState")
    private CommissionedState commissionedState;

    /*
     * Whether to do express route advertise.
     */
    @JsonProperty(value = "expressRouteAdvertise")
    private Boolean expressRouteAdvertise;

    /*
     * The Geo for CIDR advertising. Should be an Geo code.
     */
    @JsonProperty(value = "geo")
    private Geo geo;

    /*
     * Whether to Advertise the range to Internet.
     */
    @JsonProperty(value = "noInternetAdvertise")
    private Boolean noInternetAdvertise;

    /*
     * Type of custom IP prefix. Should be Singular, Parent, or Child.
     */
    @JsonProperty(value = "prefixType")
    private CustomIpPrefixType prefixType;

    /*
     * The list of all referenced PublicIpPrefixes.
     */
    @JsonProperty(value = "publicIpPrefixes", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> publicIpPrefixes;

    /*
     * The resource GUID property of the custom IP prefix resource.
     */
    @JsonProperty(value = "resourceGuid", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    /*
     * The reason why resource is in failed state.
     */
    @JsonProperty(value = "failedReason", access = JsonProperty.Access.WRITE_ONLY)
    private String failedReason;

    /*
     * The provisioning state of the custom IP prefix resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of CustomIpPrefixPropertiesFormat class.
     */
    public CustomIpPrefixPropertiesFormat() {
    }

    /**
     * Get the asn property: The ASN for CIDR advertising. Should be an integer as string.
     *
     * @return the asn value.
     */
    public String asn() {
        return this.asn;
    }

    /**
     * Set the asn property: The ASN for CIDR advertising. Should be an integer as string.
     *
     * @param asn the asn value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withAsn(String asn) {
        this.asn = asn;
        return this;
    }

    /**
     * Get the cidr property: The prefix range in CIDR notation. Should include the start address and the prefix length.
     *
     * @return the cidr value.
     */
    public String cidr() {
        return this.cidr;
    }

    /**
     * Set the cidr property: The prefix range in CIDR notation. Should include the start address and the prefix length.
     *
     * @param cidr the cidr value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withCidr(String cidr) {
        this.cidr = cidr;
        return this;
    }

    /**
     * Get the signedMessage property: Signed message for WAN validation.
     *
     * @return the signedMessage value.
     */
    public String signedMessage() {
        return this.signedMessage;
    }

    /**
     * Set the signedMessage property: Signed message for WAN validation.
     *
     * @param signedMessage the signedMessage value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withSignedMessage(String signedMessage) {
        this.signedMessage = signedMessage;
        return this;
    }

    /**
     * Get the authorizationMessage property: Authorization message for WAN validation.
     *
     * @return the authorizationMessage value.
     */
    public String authorizationMessage() {
        return this.authorizationMessage;
    }

    /**
     * Set the authorizationMessage property: Authorization message for WAN validation.
     *
     * @param authorizationMessage the authorizationMessage value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withAuthorizationMessage(String authorizationMessage) {
        this.authorizationMessage = authorizationMessage;
        return this;
    }

    /**
     * Get the customIpPrefixParent property: The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     *
     * @return the customIpPrefixParent value.
     */
    public SubResource customIpPrefixParent() {
        return this.customIpPrefixParent;
    }

    /**
     * Set the customIpPrefixParent property: The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     *
     * @param customIpPrefixParent the customIpPrefixParent value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withCustomIpPrefixParent(SubResource customIpPrefixParent) {
        this.customIpPrefixParent = customIpPrefixParent;
        return this;
    }

    /**
     * Get the childCustomIpPrefixes property: The list of all Children for IPv6 /48 CustomIpPrefix.
     *
     * @return the childCustomIpPrefixes value.
     */
    public List<SubResource> childCustomIpPrefixes() {
        return this.childCustomIpPrefixes;
    }

    /**
     * Get the commissionedState property: The commissioned state of the Custom IP Prefix.
     *
     * @return the commissionedState value.
     */
    public CommissionedState commissionedState() {
        return this.commissionedState;
    }

    /**
     * Set the commissionedState property: The commissioned state of the Custom IP Prefix.
     *
     * @param commissionedState the commissionedState value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withCommissionedState(CommissionedState commissionedState) {
        this.commissionedState = commissionedState;
        return this;
    }

    /**
     * Get the expressRouteAdvertise property: Whether to do express route advertise.
     *
     * @return the expressRouteAdvertise value.
     */
    public Boolean expressRouteAdvertise() {
        return this.expressRouteAdvertise;
    }

    /**
     * Set the expressRouteAdvertise property: Whether to do express route advertise.
     *
     * @param expressRouteAdvertise the expressRouteAdvertise value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withExpressRouteAdvertise(Boolean expressRouteAdvertise) {
        this.expressRouteAdvertise = expressRouteAdvertise;
        return this;
    }

    /**
     * Get the geo property: The Geo for CIDR advertising. Should be an Geo code.
     *
     * @return the geo value.
     */
    public Geo geo() {
        return this.geo;
    }

    /**
     * Set the geo property: The Geo for CIDR advertising. Should be an Geo code.
     *
     * @param geo the geo value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withGeo(Geo geo) {
        this.geo = geo;
        return this;
    }

    /**
     * Get the noInternetAdvertise property: Whether to Advertise the range to Internet.
     *
     * @return the noInternetAdvertise value.
     */
    public Boolean noInternetAdvertise() {
        return this.noInternetAdvertise;
    }

    /**
     * Set the noInternetAdvertise property: Whether to Advertise the range to Internet.
     *
     * @param noInternetAdvertise the noInternetAdvertise value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withNoInternetAdvertise(Boolean noInternetAdvertise) {
        this.noInternetAdvertise = noInternetAdvertise;
        return this;
    }

    /**
     * Get the prefixType property: Type of custom IP prefix. Should be Singular, Parent, or Child.
     *
     * @return the prefixType value.
     */
    public CustomIpPrefixType prefixType() {
        return this.prefixType;
    }

    /**
     * Set the prefixType property: Type of custom IP prefix. Should be Singular, Parent, or Child.
     *
     * @param prefixType the prefixType value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withPrefixType(CustomIpPrefixType prefixType) {
        this.prefixType = prefixType;
        return this;
    }

    /**
     * Get the publicIpPrefixes property: The list of all referenced PublicIpPrefixes.
     *
     * @return the publicIpPrefixes value.
     */
    public List<SubResource> publicIpPrefixes() {
        return this.publicIpPrefixes;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the custom IP prefix resource.
     *
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the failedReason property: The reason why resource is in failed state.
     *
     * @return the failedReason value.
     */
    public String failedReason() {
        return this.failedReason;
    }

    /**
     * Get the provisioningState property: The provisioning state of the custom IP prefix resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
