// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Container network interface configuration properties.
 */
@Fluent
public final class ContainerNetworkInterfaceConfigurationPropertiesFormat {
    /*
     * A list of ip configurations of the container network interface configuration.
     */
    @JsonProperty(value = "ipConfigurations")
    private List<IpConfigurationProfileInner> ipConfigurations;

    /*
     * A list of container network interfaces created from this container network interface configuration.
     */
    @JsonProperty(value = "containerNetworkInterfaces")
    private List<SubResource> containerNetworkInterfaces;

    /*
     * The provisioning state of the container network interface configuration resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ContainerNetworkInterfaceConfigurationPropertiesFormat class.
     */
    public ContainerNetworkInterfaceConfigurationPropertiesFormat() {
    }

    /**
     * Get the ipConfigurations property: A list of ip configurations of the container network interface configuration.
     * 
     * @return the ipConfigurations value.
     */
    public List<IpConfigurationProfileInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    /**
     * Set the ipConfigurations property: A list of ip configurations of the container network interface configuration.
     * 
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the ContainerNetworkInterfaceConfigurationPropertiesFormat object itself.
     */
    public ContainerNetworkInterfaceConfigurationPropertiesFormat
        withIpConfigurations(List<IpConfigurationProfileInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    /**
     * Get the containerNetworkInterfaces property: A list of container network interfaces created from this container
     * network interface configuration.
     * 
     * @return the containerNetworkInterfaces value.
     */
    public List<SubResource> containerNetworkInterfaces() {
        return this.containerNetworkInterfaces;
    }

    /**
     * Set the containerNetworkInterfaces property: A list of container network interfaces created from this container
     * network interface configuration.
     * 
     * @param containerNetworkInterfaces the containerNetworkInterfaces value to set.
     * @return the ContainerNetworkInterfaceConfigurationPropertiesFormat object itself.
     */
    public ContainerNetworkInterfaceConfigurationPropertiesFormat
        withContainerNetworkInterfaces(List<SubResource> containerNetworkInterfaces) {
        this.containerNetworkInterfaces = containerNetworkInterfaces;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the container network interface configuration
     * resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipConfigurations() != null) {
            ipConfigurations().forEach(e -> e.validate());
        }
    }
}
