// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectivityGroupItem;
import com.azure.resourcemanager.network.models.ConnectivityTopology;
import com.azure.resourcemanager.network.models.DeleteExistingPeering;
import com.azure.resourcemanager.network.models.Hub;
import com.azure.resourcemanager.network.models.IsGlobal;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Properties of network manager connectivity configuration.
 */
@Fluent
public final class ConnectivityConfigurationProperties {
    /*
     * A description of the connectivity configuration.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Connectivity topology type.
     */
    @JsonProperty(value = "connectivityTopology", required = true)
    private ConnectivityTopology connectivityTopology;

    /*
     * List of hubItems
     */
    @JsonProperty(value = "hubs")
    private List<Hub> hubs;

    /*
     * Flag if global mesh is supported.
     */
    @JsonProperty(value = "isGlobal")
    private IsGlobal isGlobal;

    /*
     * Groups for configuration
     */
    @JsonProperty(value = "appliesToGroups", required = true)
    private List<ConnectivityGroupItem> appliesToGroups;

    /*
     * The provisioning state of the connectivity configuration resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Flag if need to remove current existing peerings.
     */
    @JsonProperty(value = "deleteExistingPeering")
    private DeleteExistingPeering deleteExistingPeering;

    /*
     * Unique identifier for this resource.
     */
    @JsonProperty(value = "resourceGuid", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    /**
     * Creates an instance of ConnectivityConfigurationProperties class.
     */
    public ConnectivityConfigurationProperties() {
    }

    /**
     * Get the description property: A description of the connectivity configuration.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the connectivity configuration.
     *
     * @param description the description value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the connectivityTopology property: Connectivity topology type.
     *
     * @return the connectivityTopology value.
     */
    public ConnectivityTopology connectivityTopology() {
        return this.connectivityTopology;
    }

    /**
     * Set the connectivityTopology property: Connectivity topology type.
     *
     * @param connectivityTopology the connectivityTopology value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withConnectivityTopology(ConnectivityTopology connectivityTopology) {
        this.connectivityTopology = connectivityTopology;
        return this;
    }

    /**
     * Get the hubs property: List of hubItems.
     *
     * @return the hubs value.
     */
    public List<Hub> hubs() {
        return this.hubs;
    }

    /**
     * Set the hubs property: List of hubItems.
     *
     * @param hubs the hubs value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withHubs(List<Hub> hubs) {
        this.hubs = hubs;
        return this;
    }

    /**
     * Get the isGlobal property: Flag if global mesh is supported.
     *
     * @return the isGlobal value.
     */
    public IsGlobal isGlobal() {
        return this.isGlobal;
    }

    /**
     * Set the isGlobal property: Flag if global mesh is supported.
     *
     * @param isGlobal the isGlobal value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withIsGlobal(IsGlobal isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    /**
     * Get the appliesToGroups property: Groups for configuration.
     *
     * @return the appliesToGroups value.
     */
    public List<ConnectivityGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    /**
     * Set the appliesToGroups property: Groups for configuration.
     *
     * @param appliesToGroups the appliesToGroups value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withAppliesToGroups(List<ConnectivityGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the connectivity configuration resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deleteExistingPeering property: Flag if need to remove current existing peerings.
     *
     * @return the deleteExistingPeering value.
     */
    public DeleteExistingPeering deleteExistingPeering() {
        return this.deleteExistingPeering;
    }

    /**
     * Set the deleteExistingPeering property: Flag if need to remove current existing peerings.
     *
     * @param deleteExistingPeering the deleteExistingPeering value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withDeleteExistingPeering(DeleteExistingPeering deleteExistingPeering) {
        this.deleteExistingPeering = deleteExistingPeering;
        return this;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     *
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectivityTopology() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectivityTopology in model ConnectivityConfigurationProperties"));
        }
        if (hubs() != null) {
            hubs().forEach(e -> e.validate());
        }
        if (appliesToGroups() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property appliesToGroups in model ConnectivityConfigurationProperties"));
        } else {
            appliesToGroups().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityConfigurationProperties.class);
}
