// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of Frontend port of an application gateway.
 */
@Fluent
public final class ApplicationGatewayFrontendPortPropertiesFormat {
    /*
     * Frontend port.
     */
    @JsonProperty(value = "port")
    private Integer port;

    /*
     * The provisioning state of the frontend port resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayFrontendPortPropertiesFormat class.
     */
    public ApplicationGatewayFrontendPortPropertiesFormat() {
    }

    /**
     * Get the port property: Frontend port.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: Frontend port.
     * 
     * @param port the port value to set.
     * @return the ApplicationGatewayFrontendPortPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendPortPropertiesFormat withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the frontend port resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
