/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.ExpressRouteCircuitPeeringsClient;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.implementation.ExpressRouteCircuitImpl;
import com.azure.resourcemanager.network.implementation.ExpressRouteCircuitPeeringImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCircuit;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeering;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeerings;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import reactor.core.publisher.Mono;

class ExpressRouteCircuitPeeringsImpl
extends IndependentChildrenImpl<ExpressRouteCircuitPeering, ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl>, ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeeringsClient, NetworkManager, ExpressRouteCircuit>
implements ExpressRouteCircuitPeerings {
    private final ExpressRouteCircuitImpl parent;

    ExpressRouteCircuitPeeringsImpl(ExpressRouteCircuitImpl parent) {
        super((Object)((NetworkManagementClient)((NetworkManager)parent.manager()).serviceClient()).getExpressRouteCircuitPeerings(), (Manager)((NetworkManager)parent.manager()));
        this.parent = parent;
    }

    public final PagedIterable<ExpressRouteCircuitPeering> list() {
        return this.wrapList(((ExpressRouteCircuitPeeringsClient)this.innerModel()).list(this.parent.resourceGroupName(), this.parent.name()));
    }

    public PagedFlux<ExpressRouteCircuitPeering> listAsync() {
        return this.wrapPageAsync(((ExpressRouteCircuitPeeringsClient)this.innerModel()).listAsync(this.parent.resourceGroupName(), this.parent.name()));
    }

    protected ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl> wrapModel(String name) {
        return new ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl>(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsClient)this.innerModel(), ExpressRoutePeeringType.fromString(name));
    }

    protected ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl> wrapModel(ExpressRouteCircuitPeeringInner inner) {
        return inner == null ? null : new ExpressRouteCircuitPeeringImpl(this.parent, inner, (ExpressRouteCircuitPeeringsClient)this.innerModel(), inner.peeringType());
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl> defineAzurePrivatePeering() {
        return new ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl>(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsClient)this.innerModel(), ExpressRoutePeeringType.AZURE_PRIVATE_PEERING);
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl> defineAzurePublicPeering() {
        return new ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl>(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsClient)this.innerModel(), ExpressRoutePeeringType.AZURE_PUBLIC_PEERING);
    }

    @Override
    public ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl> defineMicrosoftPeering() {
        return new ExpressRouteCircuitPeeringImpl<ExpressRouteCircuit, ExpressRouteCircuitInner, ExpressRouteCircuitImpl>(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsClient)this.innerModel(), ExpressRoutePeeringType.MICROSOFT_PEERING);
    }

    public Mono<ExpressRouteCircuitPeering> getByNameAsync(String name) {
        return ((ExpressRouteCircuitPeeringsClient)this.innerModel()).getAsync(this.parent.resourceGroupName(), this.parent.name(), name).map(inner -> this.wrapModel((ExpressRouteCircuitPeeringInner)((Object)inner)));
    }

    public ExpressRouteCircuitPeering getByName(String name) {
        return (ExpressRouteCircuitPeering)this.getByNameAsync(name).block();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return ((ExpressRouteCircuitPeeringsClient)this.innerModel()).deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public ExpressRouteCircuit parent() {
        return this.parent;
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        return ((ExpressRouteCircuitPeeringsClient)this.innerModel()).deleteAsync(groupName, parentName, name);
    }

    public Mono<ExpressRouteCircuitPeering> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((ExpressRouteCircuitPeeringsClient)this.innerModel()).getAsync(resourceGroup, parentName, name).map(inner -> this.wrapModel((ExpressRouteCircuitPeeringInner)((Object)inner)));
    }

    public PagedIterable<ExpressRouteCircuitPeering> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((ExpressRouteCircuitPeeringsClient)this.innerModel()).list(resourceGroupName, parentName));
    }
}

