/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.implementation.Utils;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayIpConfiguration;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

class ApplicationGatewayIpConfigurationImpl
extends ChildResourceImpl<ApplicationGatewayIpConfigurationInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayIpConfiguration,
ApplicationGatewayIpConfiguration.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayIpConfiguration.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayIpConfiguration.Update {
    ApplicationGatewayIpConfigurationImpl(ApplicationGatewayIpConfigurationInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ApplicationGatewayIpConfigurationInner)((Object)this.innerModel())).name();
    }

    @Override
    public ApplicationGatewayIpConfigurationImpl withExistingSubnet(Subnet subnet) {
        return this.withExistingSubnet(((Network)subnet.parent()).id(), subnet.name());
    }

    @Override
    public ApplicationGatewayIpConfigurationImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public ApplicationGatewayIpConfigurationImpl withExistingSubnet(String networkId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(networkId + "/subnets/" + subnetName);
        ((ApplicationGatewayIpConfigurationInner)((Object)this.innerModel())).withSubnet(subnetRef);
        return this;
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withConfig(this);
    }

    @Override
    public String networkId() {
        SubResource subnetRef = ((ApplicationGatewayIpConfigurationInner)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String subnetName() {
        SubResource subnetRef = ((ApplicationGatewayIpConfigurationInner)((Object)this.innerModel())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public Subnet getSubnet() {
        return Utils.getAssociatedSubnet((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager(), ((ApplicationGatewayIpConfigurationInner)((Object)this.innerModel())).subnet());
    }
}

