// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The rule type.
 */
public final class WebApplicationFirewallRuleType extends ExpandableStringEnum<WebApplicationFirewallRuleType> {
    /**
     * Static value MatchRule for WebApplicationFirewallRuleType.
     */
    public static final WebApplicationFirewallRuleType MATCH_RULE = fromString("MatchRule");

    /**
     * Static value RateLimitRule for WebApplicationFirewallRuleType.
     */
    public static final WebApplicationFirewallRuleType RATE_LIMIT_RULE = fromString("RateLimitRule");

    /**
     * Static value Invalid for WebApplicationFirewallRuleType.
     */
    public static final WebApplicationFirewallRuleType INVALID = fromString("Invalid");

    /**
     * Creates a new instance of WebApplicationFirewallRuleType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public WebApplicationFirewallRuleType() {
    }

    /**
     * Creates or finds a WebApplicationFirewallRuleType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding WebApplicationFirewallRuleType.
     */
    @JsonCreator
    public static WebApplicationFirewallRuleType fromString(String name) {
        return fromString(name, WebApplicationFirewallRuleType.class);
    }

    /**
     * Gets known WebApplicationFirewallRuleType values.
     * 
     * @return known WebApplicationFirewallRuleType values.
     */
    public static Collection<WebApplicationFirewallRuleType> values() {
        return values(WebApplicationFirewallRuleType.class);
    }
}
