// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Stop packet capture parameters.
 */
@Fluent
public final class VpnGatewayPacketCaptureStopParameters {
    /*
     * SAS url for packet capture on vpn gateway.
     */
    @JsonProperty(value = "sasUrl")
    private String sasUrl;

    /**
     * Creates an instance of VpnGatewayPacketCaptureStopParameters class.
     */
    public VpnGatewayPacketCaptureStopParameters() {
    }

    /**
     * Get the sasUrl property: SAS url for packet capture on vpn gateway.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url for packet capture on vpn gateway.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the VpnGatewayPacketCaptureStopParameters object itself.
     */
    public VpnGatewayPacketCaptureStopParameters withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
