// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The current state of the vpn connection.
 */
public final class VpnConnectionStatus extends ExpandableStringEnum<VpnConnectionStatus> {
    /**
     * Static value Unknown for VpnConnectionStatus.
     */
    public static final VpnConnectionStatus UNKNOWN = fromString("Unknown");

    /**
     * Static value Connecting for VpnConnectionStatus.
     */
    public static final VpnConnectionStatus CONNECTING = fromString("Connecting");

    /**
     * Static value Connected for VpnConnectionStatus.
     */
    public static final VpnConnectionStatus CONNECTED = fromString("Connected");

    /**
     * Static value NotConnected for VpnConnectionStatus.
     */
    public static final VpnConnectionStatus NOT_CONNECTED = fromString("NotConnected");

    /**
     * Creates a new instance of VpnConnectionStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VpnConnectionStatus() {
    }

    /**
     * Creates or finds a VpnConnectionStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VpnConnectionStatus.
     */
    @JsonCreator
    public static VpnConnectionStatus fromString(String name) {
        return fromString(name, VpnConnectionStatus.class);
    }

    /**
     * Gets known VpnConnectionStatus values.
     * 
     * @return known VpnConnectionStatus values.
     */
    public static Collection<VpnConnectionStatus> values() {
        return values(VpnConnectionStatus.class);
    }
}
