// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Network Virtual Appliance Additional Nic Properties
 * 
 * Network Virtual Appliance Additional NIC properties.
 */
@Fluent
public final class VirtualApplianceAdditionalNicProperties {
    /*
     * Name of additional nic
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Flag (true or false) for Intent for Public Ip on additional nic
     */
    @JsonProperty(value = "hasPublicIp")
    private Boolean hasPublicIp;

    /**
     * Creates an instance of VirtualApplianceAdditionalNicProperties class.
     */
    public VirtualApplianceAdditionalNicProperties() {
    }

    /**
     * Get the name property: Name of additional nic.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of additional nic.
     * 
     * @param name the name value to set.
     * @return the VirtualApplianceAdditionalNicProperties object itself.
     */
    public VirtualApplianceAdditionalNicProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the hasPublicIp property: Flag (true or false) for Intent for Public Ip on additional nic.
     * 
     * @return the hasPublicIp value.
     */
    public Boolean hasPublicIp() {
        return this.hasPublicIp;
    }

    /**
     * Set the hasPublicIp property: Flag (true or false) for Intent for Public Ip on additional nic.
     * 
     * @param hasPublicIp the hasPublicIp value to set.
     * @return the VirtualApplianceAdditionalNicProperties object itself.
     */
    public VirtualApplianceAdditionalNicProperties withHasPublicIp(Boolean hasPublicIp) {
        this.hasPublicIp = hasPublicIp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
