// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Configuration for static routes on this HubVnetConnectionConfiguration for static routes on this HubVnetConnection.
 */
@Fluent
public final class StaticRoutesConfig {
    /*
     * Boolean indicating whether static routes on this connection are automatically propagate to route tables which
     * this connection propagates to.
     */
    @JsonProperty(value = "propagateStaticRoutes", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean propagateStaticRoutes;

    /*
     * Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
     */
    @JsonProperty(value = "vnetLocalRouteOverrideCriteria")
    private VnetLocalRouteOverrideCriteria vnetLocalRouteOverrideCriteria;

    /**
     * Creates an instance of StaticRoutesConfig class.
     */
    public StaticRoutesConfig() {
    }

    /**
     * Get the propagateStaticRoutes property: Boolean indicating whether static routes on this connection are
     * automatically propagate to route tables which this connection propagates to.
     * 
     * @return the propagateStaticRoutes value.
     */
    public Boolean propagateStaticRoutes() {
        return this.propagateStaticRoutes;
    }

    /**
     * Get the vnetLocalRouteOverrideCriteria property: Parameter determining whether NVA in spoke vnet is bypassed for
     * traffic with destination in spoke.
     * 
     * @return the vnetLocalRouteOverrideCriteria value.
     */
    public VnetLocalRouteOverrideCriteria vnetLocalRouteOverrideCriteria() {
        return this.vnetLocalRouteOverrideCriteria;
    }

    /**
     * Set the vnetLocalRouteOverrideCriteria property: Parameter determining whether NVA in spoke vnet is bypassed for
     * traffic with destination in spoke.
     * 
     * @param vnetLocalRouteOverrideCriteria the vnetLocalRouteOverrideCriteria value to set.
     * @return the StaticRoutesConfig object itself.
     */
    public StaticRoutesConfig
        withVnetLocalRouteOverrideCriteria(VnetLocalRouteOverrideCriteria vnetLocalRouteOverrideCriteria) {
        this.vnetLocalRouteOverrideCriteria = vnetLocalRouteOverrideCriteria;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
