// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Will contain the properties of the resource (the actual signature overrides).
 */
@Fluent
public final class SignaturesOverridesProperties {
    /*
     * Dictionary of <string>
     */
    @JsonProperty(value = "signatures")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> signatures;

    /**
     * Creates an instance of SignaturesOverridesProperties class.
     */
    public SignaturesOverridesProperties() {
    }

    /**
     * Get the signatures property: Dictionary of &lt;string&gt;.
     * 
     * @return the signatures value.
     */
    public Map<String, String> signatures() {
        return this.signatures;
    }

    /**
     * Set the signatures property: Dictionary of &lt;string&gt;.
     * 
     * @param signatures the signatures value to set.
     * @return the SignaturesOverridesProperties object itself.
     */
    public SignaturesOverridesProperties withSignatures(Map<String, String> signatures) {
        this.signatures = signatures;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
