// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Parameters for an Action.
 */
@Fluent
public final class Parameter {
    /*
     * List of route prefixes.
     */
    @JsonProperty(value = "routePrefix")
    private List<String> routePrefix;

    /*
     * List of BGP communities.
     */
    @JsonProperty(value = "community")
    private List<String> community;

    /*
     * List of AS paths.
     */
    @JsonProperty(value = "asPath")
    private List<String> asPath;

    /**
     * Creates an instance of Parameter class.
     */
    public Parameter() {
    }

    /**
     * Get the routePrefix property: List of route prefixes.
     * 
     * @return the routePrefix value.
     */
    public List<String> routePrefix() {
        return this.routePrefix;
    }

    /**
     * Set the routePrefix property: List of route prefixes.
     * 
     * @param routePrefix the routePrefix value to set.
     * @return the Parameter object itself.
     */
    public Parameter withRoutePrefix(List<String> routePrefix) {
        this.routePrefix = routePrefix;
        return this;
    }

    /**
     * Get the community property: List of BGP communities.
     * 
     * @return the community value.
     */
    public List<String> community() {
        return this.community;
    }

    /**
     * Set the community property: List of BGP communities.
     * 
     * @param community the community value to set.
     * @return the Parameter object itself.
     */
    public Parameter withCommunity(List<String> community) {
        this.community = community;
        return this;
    }

    /**
     * Get the asPath property: List of AS paths.
     * 
     * @return the asPath value.
     */
    public List<String> asPath() {
        return this.asPath;
    }

    /**
     * Set the asPath property: List of AS paths.
     * 
     * @param asPath the asPath value to set.
     * @return the Parameter object itself.
     */
    public Parameter withAsPath(List<String> asPath) {
        this.asPath = asPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
