// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Response for ListNetworkSecurityGroups API service call.
 */
@Fluent
public final class NetworkSecurityGroupListResult {
    /*
     * A list of NetworkSecurityGroup resources.
     */
    @JsonProperty(value = "value")
    private List<NetworkSecurityGroupInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of NetworkSecurityGroupListResult class.
     */
    public NetworkSecurityGroupListResult() {
    }

    /**
     * Get the value property: A list of NetworkSecurityGroup resources.
     * 
     * @return the value value.
     */
    public List<NetworkSecurityGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of NetworkSecurityGroup resources.
     * 
     * @param value the value value to set.
     * @return the NetworkSecurityGroupListResult object itself.
     */
    public NetworkSecurityGroupListResult withValue(List<NetworkSecurityGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NetworkSecurityGroupListResult object itself.
     */
    public NetworkSecurityGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
