// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Migration phase of Network Interface resource.
 */
public final class NetworkInterfaceMigrationPhase extends ExpandableStringEnum<NetworkInterfaceMigrationPhase> {
    /**
     * Static value None for NetworkInterfaceMigrationPhase.
     */
    public static final NetworkInterfaceMigrationPhase NONE = fromString("None");

    /**
     * Static value Prepare for NetworkInterfaceMigrationPhase.
     */
    public static final NetworkInterfaceMigrationPhase PREPARE = fromString("Prepare");

    /**
     * Static value Commit for NetworkInterfaceMigrationPhase.
     */
    public static final NetworkInterfaceMigrationPhase COMMIT = fromString("Commit");

    /**
     * Static value Abort for NetworkInterfaceMigrationPhase.
     */
    public static final NetworkInterfaceMigrationPhase ABORT = fromString("Abort");

    /**
     * Static value Committed for NetworkInterfaceMigrationPhase.
     */
    public static final NetworkInterfaceMigrationPhase COMMITTED = fromString("Committed");

    /**
     * Creates a new instance of NetworkInterfaceMigrationPhase value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NetworkInterfaceMigrationPhase() {
    }

    /**
     * Creates or finds a NetworkInterfaceMigrationPhase from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NetworkInterfaceMigrationPhase.
     */
    @JsonCreator
    public static NetworkInterfaceMigrationPhase fromString(String name) {
        return fromString(name, NetworkInterfaceMigrationPhase.class);
    }

    /**
     * Gets known NetworkInterfaceMigrationPhase values.
     * 
     * @return known NetworkInterfaceMigrationPhase values.
     */
    public static Collection<NetworkInterfaceMigrationPhase> values() {
        return values(NetworkInterfaceMigrationPhase.class);
    }
}
