// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Response for ListOutboundRule API service call.
 */
@Fluent
public final class LoadBalancerOutboundRuleListResult {
    /*
     * A list of outbound rules in a load balancer.
     */
    @JsonProperty(value = "value")
    private List<OutboundRuleInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Creates an instance of LoadBalancerOutboundRuleListResult class.
     */
    public LoadBalancerOutboundRuleListResult() {
    }

    /**
     * Get the value property: A list of outbound rules in a load balancer.
     * 
     * @return the value value.
     */
    public List<OutboundRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of outbound rules in a load balancer.
     * 
     * @param value the value value to set.
     * @return the LoadBalancerOutboundRuleListResult object itself.
     */
    public LoadBalancerOutboundRuleListResult withValue(List<OutboundRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
