// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Define user session identifier group by clauses.
 */
@Fluent
public final class GroupByUserSession {
    /*
     * List of group by clause variables.
     */
    @JsonProperty(value = "groupByVariables", required = true)
    private List<GroupByVariable> groupByVariables;

    /**
     * Creates an instance of GroupByUserSession class.
     */
    public GroupByUserSession() {
    }

    /**
     * Get the groupByVariables property: List of group by clause variables.
     * 
     * @return the groupByVariables value.
     */
    public List<GroupByVariable> groupByVariables() {
        return this.groupByVariables;
    }

    /**
     * Set the groupByVariables property: List of group by clause variables.
     * 
     * @param groupByVariables the groupByVariables value to set.
     * @return the GroupByUserSession object itself.
     */
    public GroupByUserSession withGroupByVariables(List<GroupByVariable> groupByVariables) {
        this.groupByVariables = groupByVariables;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (groupByVariables() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property groupByVariables in model GroupByUserSession"));
        } else {
            groupByVariables().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GroupByUserSession.class);
}
