// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * SwapResource List with single entry to represent slot type on the specified cloud service.
 */
@Fluent
public final class SwapResourceListResultInner {
    /*
     * The value property.
     */
    @JsonProperty(value = "value")
    private List<SwapResourceInner> value;

    /**
     * Creates an instance of SwapResourceListResultInner class.
     */
    public SwapResourceListResultInner() {
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public List<SwapResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the SwapResourceListResultInner object itself.
     */
    public SwapResourceListResultInner withValue(List<SwapResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
