// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Properties of the NetworkVirtualApplianceConnection subresource.
 */
@Fluent
public final class NetworkVirtualApplianceConnectionProperties {
    /*
     * The name of the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The provisioning state of the NetworkVirtualApplianceConnection resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Network Virtual Appliance ASN.
     */
    @JsonProperty(value = "asn")
    private Long asn;

    /*
     * Unique identifier for the connection.
     */
    @JsonProperty(value = "tunnelIdentifier")
    private Long tunnelIdentifier;

    /*
     * List of bgpPeerAddresses for the NVA instances
     */
    @JsonProperty(value = "bgpPeerAddress")
    private List<String> bgpPeerAddress;

    /*
     * Enable internet security.
     */
    @JsonProperty(value = "enableInternetSecurity")
    private Boolean enableInternetSecurity;

    /*
     * The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JsonProperty(value = "routingConfiguration")
    private RoutingConfiguration routingConfiguration;

    /**
     * Creates an instance of NetworkVirtualApplianceConnectionProperties class.
     */
    public NetworkVirtualApplianceConnectionProperties() {
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource.
     * 
     * @param name the name value to set.
     * @return the NetworkVirtualApplianceConnectionProperties object itself.
     */
    public NetworkVirtualApplianceConnectionProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the NetworkVirtualApplianceConnection resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the asn property: Network Virtual Appliance ASN.
     * 
     * @return the asn value.
     */
    public Long asn() {
        return this.asn;
    }

    /**
     * Set the asn property: Network Virtual Appliance ASN.
     * 
     * @param asn the asn value to set.
     * @return the NetworkVirtualApplianceConnectionProperties object itself.
     */
    public NetworkVirtualApplianceConnectionProperties withAsn(Long asn) {
        this.asn = asn;
        return this;
    }

    /**
     * Get the tunnelIdentifier property: Unique identifier for the connection.
     * 
     * @return the tunnelIdentifier value.
     */
    public Long tunnelIdentifier() {
        return this.tunnelIdentifier;
    }

    /**
     * Set the tunnelIdentifier property: Unique identifier for the connection.
     * 
     * @param tunnelIdentifier the tunnelIdentifier value to set.
     * @return the NetworkVirtualApplianceConnectionProperties object itself.
     */
    public NetworkVirtualApplianceConnectionProperties withTunnelIdentifier(Long tunnelIdentifier) {
        this.tunnelIdentifier = tunnelIdentifier;
        return this;
    }

    /**
     * Get the bgpPeerAddress property: List of bgpPeerAddresses for the NVA instances.
     * 
     * @return the bgpPeerAddress value.
     */
    public List<String> bgpPeerAddress() {
        return this.bgpPeerAddress;
    }

    /**
     * Set the bgpPeerAddress property: List of bgpPeerAddresses for the NVA instances.
     * 
     * @param bgpPeerAddress the bgpPeerAddress value to set.
     * @return the NetworkVirtualApplianceConnectionProperties object itself.
     */
    public NetworkVirtualApplianceConnectionProperties withBgpPeerAddress(List<String> bgpPeerAddress) {
        this.bgpPeerAddress = bgpPeerAddress;
        return this;
    }

    /**
     * Get the enableInternetSecurity property: Enable internet security.
     * 
     * @return the enableInternetSecurity value.
     */
    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    /**
     * Set the enableInternetSecurity property: Enable internet security.
     * 
     * @param enableInternetSecurity the enableInternetSecurity value to set.
     * @return the NetworkVirtualApplianceConnectionProperties object itself.
     */
    public NetworkVirtualApplianceConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    /**
     * Get the routingConfiguration property: The Routing Configuration indicating the associated and propagated route
     * tables on this connection.
     * 
     * @return the routingConfiguration value.
     */
    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    /**
     * Set the routingConfiguration property: The Routing Configuration indicating the associated and propagated route
     * tables on this connection.
     * 
     * @param routingConfiguration the routingConfiguration value to set.
     * @return the NetworkVirtualApplianceConnectionProperties object itself.
     */
    public NetworkVirtualApplianceConnectionProperties
        withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routingConfiguration() != null) {
            routingConfiguration().validate();
        }
    }
}
