// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ExpressRouteLinkAdminState;
import com.azure.resourcemanager.network.models.ExpressRouteLinkConnectorType;
import com.azure.resourcemanager.network.models.ExpressRouteLinkMacSecConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * ExpressRouteLink Resource Properties
 * 
 * Properties specific to ExpressRouteLink resources.
 */
@Fluent
public final class ExpressRouteLinkPropertiesFormat {
    /*
     * Name of Azure router associated with physical port.
     */
    @JsonProperty(value = "routerName", access = JsonProperty.Access.WRITE_ONLY)
    private String routerName;

    /*
     * Name of Azure router interface.
     */
    @JsonProperty(value = "interfaceName", access = JsonProperty.Access.WRITE_ONLY)
    private String interfaceName;

    /*
     * Mapping between physical port to patch panel port.
     */
    @JsonProperty(value = "patchPanelId", access = JsonProperty.Access.WRITE_ONLY)
    private String patchPanelId;

    /*
     * Mapping of physical patch panel to rack.
     */
    @JsonProperty(value = "rackId", access = JsonProperty.Access.WRITE_ONLY)
    private String rackId;

    /*
     * Cololocation for ExpressRoute Hybrid Direct.
     */
    @JsonProperty(value = "coloLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String coloLocation;

    /*
     * Physical fiber port type.
     */
    @JsonProperty(value = "connectorType", access = JsonProperty.Access.WRITE_ONLY)
    private ExpressRouteLinkConnectorType connectorType;

    /*
     * Administrative state of the physical port.
     */
    @JsonProperty(value = "adminState")
    private ExpressRouteLinkAdminState adminState;

    /*
     * The provisioning state of the express route link resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Definition of ExpressRouteLink Mac Security configuration.
     * 
     * MacSec configuration.
     */
    @JsonProperty(value = "macSecConfig")
    private ExpressRouteLinkMacSecConfig macSecConfig;

    /**
     * Creates an instance of ExpressRouteLinkPropertiesFormat class.
     */
    public ExpressRouteLinkPropertiesFormat() {
    }

    /**
     * Get the routerName property: Name of Azure router associated with physical port.
     * 
     * @return the routerName value.
     */
    public String routerName() {
        return this.routerName;
    }

    /**
     * Get the interfaceName property: Name of Azure router interface.
     * 
     * @return the interfaceName value.
     */
    public String interfaceName() {
        return this.interfaceName;
    }

    /**
     * Get the patchPanelId property: Mapping between physical port to patch panel port.
     * 
     * @return the patchPanelId value.
     */
    public String patchPanelId() {
        return this.patchPanelId;
    }

    /**
     * Get the rackId property: Mapping of physical patch panel to rack.
     * 
     * @return the rackId value.
     */
    public String rackId() {
        return this.rackId;
    }

    /**
     * Get the coloLocation property: Cololocation for ExpressRoute Hybrid Direct.
     * 
     * @return the coloLocation value.
     */
    public String coloLocation() {
        return this.coloLocation;
    }

    /**
     * Get the connectorType property: Physical fiber port type.
     * 
     * @return the connectorType value.
     */
    public ExpressRouteLinkConnectorType connectorType() {
        return this.connectorType;
    }

    /**
     * Get the adminState property: Administrative state of the physical port.
     * 
     * @return the adminState value.
     */
    public ExpressRouteLinkAdminState adminState() {
        return this.adminState;
    }

    /**
     * Set the adminState property: Administrative state of the physical port.
     * 
     * @param adminState the adminState value to set.
     * @return the ExpressRouteLinkPropertiesFormat object itself.
     */
    public ExpressRouteLinkPropertiesFormat withAdminState(ExpressRouteLinkAdminState adminState) {
        this.adminState = adminState;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the express route link resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the macSecConfig property: Definition of ExpressRouteLink Mac Security configuration.
     * 
     * MacSec configuration.
     * 
     * @return the macSecConfig value.
     */
    public ExpressRouteLinkMacSecConfig macSecConfig() {
        return this.macSecConfig;
    }

    /**
     * Set the macSecConfig property: Definition of ExpressRouteLink Mac Security configuration.
     * 
     * MacSec configuration.
     * 
     * @param macSecConfig the macSecConfig value to set.
     * @return the ExpressRouteLinkPropertiesFormat object itself.
     */
    public ExpressRouteLinkPropertiesFormat withMacSecConfig(ExpressRouteLinkMacSecConfig macSecConfig) {
        this.macSecConfig = macSecConfig;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (macSecConfig() != null) {
            macSecConfig().validate();
        }
    }
}
