// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.AuthorizationUseStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of ExpressRouteCircuitAuthorization.
 */
@Fluent
public final class AuthorizationPropertiesFormat {
    /*
     * The authorization key.
     */
    @JsonProperty(value = "authorizationKey")
    private String authorizationKey;

    /*
     * The authorization use status.
     */
    @JsonProperty(value = "authorizationUseStatus")
    private AuthorizationUseStatus authorizationUseStatus;

    /*
     * The provisioning state of the authorization resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of AuthorizationPropertiesFormat class.
     */
    public AuthorizationPropertiesFormat() {
    }

    /**
     * Get the authorizationKey property: The authorization key.
     * 
     * @return the authorizationKey value.
     */
    public String authorizationKey() {
        return this.authorizationKey;
    }

    /**
     * Set the authorizationKey property: The authorization key.
     * 
     * @param authorizationKey the authorizationKey value to set.
     * @return the AuthorizationPropertiesFormat object itself.
     */
    public AuthorizationPropertiesFormat withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    /**
     * Get the authorizationUseStatus property: The authorization use status.
     * 
     * @return the authorizationUseStatus value.
     */
    public AuthorizationUseStatus authorizationUseStatus() {
        return this.authorizationUseStatus;
    }

    /**
     * Set the authorizationUseStatus property: The authorization use status.
     * 
     * @param authorizationUseStatus the authorizationUseStatus value to set.
     * @return the AuthorizationPropertiesFormat object itself.
     */
    public AuthorizationPropertiesFormat withAuthorizationUseStatus(AuthorizationUseStatus authorizationUseStatus) {
        this.authorizationUseStatus = authorizationUseStatus;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the authorization resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
