// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Vpn Connection packet capture parameters supplied to stop packet capture on gateway connection.
 */
@Fluent
public final class VpnConnectionPacketCaptureStopParameters {
    /*
     * SAS url for packet capture on vpn connection.
     */
    @JsonProperty(value = "sasUrl")
    private String sasUrl;

    /*
     * List of site link connection names.
     */
    @JsonProperty(value = "linkConnectionNames")
    private List<String> linkConnectionNames;

    /**
     * Creates an instance of VpnConnectionPacketCaptureStopParameters class.
     */
    public VpnConnectionPacketCaptureStopParameters() {
    }

    /**
     * Get the sasUrl property: SAS url for packet capture on vpn connection.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url for packet capture on vpn connection.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the VpnConnectionPacketCaptureStopParameters object itself.
     */
    public VpnConnectionPacketCaptureStopParameters withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get the linkConnectionNames property: List of site link connection names.
     * 
     * @return the linkConnectionNames value.
     */
    public List<String> linkConnectionNames() {
        return this.linkConnectionNames;
    }

    /**
     * Set the linkConnectionNames property: List of site link connection names.
     * 
     * @param linkConnectionNames the linkConnectionNames value to set.
     * @return the VpnConnectionPacketCaptureStopParameters object itself.
     */
    public VpnConnectionPacketCaptureStopParameters withLinkConnectionNames(List<String> linkConnectionNames) {
        this.linkConnectionNames = linkConnectionNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
