// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters that define the VM to check security groups for.
 */
@Fluent
public final class SecurityGroupViewParameters {
    /*
     * ID of the target VM.
     */
    @JsonProperty(value = "targetResourceId", required = true)
    private String targetResourceId;

    /**
     * Creates an instance of SecurityGroupViewParameters class.
     */
    public SecurityGroupViewParameters() {
    }

    /**
     * Get the targetResourceId property: ID of the target VM.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set the targetResourceId property: ID of the target VM.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @return the SecurityGroupViewParameters object itself.
     */
    public SecurityGroupViewParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetResourceId() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property targetResourceId in model SecurityGroupViewParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SecurityGroupViewParameters.class);
}
