// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The type of Azure hop the packet should be sent to.
 */
public final class RouteNextHopType extends ExpandableStringEnum<RouteNextHopType> {
    /**
     * Static value VirtualNetworkGateway for RouteNextHopType.
     */
    public static final RouteNextHopType VIRTUAL_NETWORK_GATEWAY = fromString("VirtualNetworkGateway");

    /**
     * Static value VnetLocal for RouteNextHopType.
     */
    public static final RouteNextHopType VNET_LOCAL = fromString("VnetLocal");

    /**
     * Static value Internet for RouteNextHopType.
     */
    public static final RouteNextHopType INTERNET = fromString("Internet");

    /**
     * Static value VirtualAppliance for RouteNextHopType.
     */
    public static final RouteNextHopType VIRTUAL_APPLIANCE = fromString("VirtualAppliance");

    /**
     * Static value None for RouteNextHopType.
     */
    public static final RouteNextHopType NONE = fromString("None");

    /**
     * Creates a new instance of RouteNextHopType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RouteNextHopType() {
    }

    /**
     * Creates or finds a RouteNextHopType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RouteNextHopType.
     */
    @JsonCreator
    public static RouteNextHopType fromString(String name) {
        return fromString(name, RouteNextHopType.class);
    }

    /**
     * Gets known RouteNextHopType values.
     * 
     * @return known RouteNextHopType values.
     */
    public static Collection<RouteNextHopType> values() {
        return values(RouteNextHopType.class);
    }
}
