// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in
 * the vnet.
 */
public final class AdminState extends ExpandableStringEnum<AdminState> {
    /**
     * Static value Enabled for AdminState.
     */
    public static final AdminState ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for AdminState.
     */
    public static final AdminState DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of AdminState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AdminState() {
    }

    /**
     * Creates or finds a AdminState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AdminState.
     */
    @JsonCreator
    public static AdminState fromString(String name) {
        return fromString(name, AdminState.class);
    }

    /**
     * Gets known AdminState values.
     * 
     * @return known AdminState values.
     */
    public static Collection<AdminState> values() {
        return values(AdminState.class);
    }
}
