// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.RouteMapInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in RouteMapsClient.
 */
public interface RouteMapsClient {
    /**
     * Retrieves the details of a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RouteMapInner>> getWithResponseAsync(String resourceGroupName, String virtualHubName,
        String routeMapName);

    /**
     * Retrieves the details of a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RouteMapInner> getAsync(String resourceGroupName, String virtualHubName, String routeMapName);

    /**
     * Retrieves the details of a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RouteMapInner> getWithResponse(String resourceGroupName, String virtualHubName, String routeMapName,
        Context context);

    /**
     * Retrieves the details of a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RouteMapInner get(String resourceGroupName, String virtualHubName, String routeMapName);

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualHubName,
        String routeMapName, RouteMapInner routeMapParameters);

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<RouteMapInner>, RouteMapInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String virtualHubName, String routeMapName, RouteMapInner routeMapParameters);

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<RouteMapInner>, RouteMapInner> beginCreateOrUpdate(String resourceGroupName,
        String virtualHubName, String routeMapName, RouteMapInner routeMapParameters);

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<RouteMapInner>, RouteMapInner> beginCreateOrUpdate(String resourceGroupName,
        String virtualHubName, String routeMapName, RouteMapInner routeMapParameters, Context context);

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RouteMapInner> createOrUpdateAsync(String resourceGroupName, String virtualHubName, String routeMapName,
        RouteMapInner routeMapParameters);

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RouteMapInner createOrUpdate(String resourceGroupName, String virtualHubName, String routeMapName,
        RouteMapInner routeMapParameters);

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RouteMapInner createOrUpdate(String resourceGroupName, String virtualHubName, String routeMapName,
        RouteMapInner routeMapParameters, Context context);

    /**
     * Deletes a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualHubName,
        String routeMapName);

    /**
     * Deletes a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualHubName,
        String routeMapName);

    /**
     * Deletes a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName,
        String routeMapName);

    /**
     * Deletes a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualHubName, String routeMapName,
        Context context);

    /**
     * Deletes a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeMapName);

    /**
     * Deletes a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String virtualHubName, String routeMapName);

    /**
     * Deletes a RouteMap.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String virtualHubName, String routeMapName, Context context);

    /**
     * Retrieves the details of all RouteMaps.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RouteMapInner> listAsync(String resourceGroupName, String virtualHubName);

    /**
     * Retrieves the details of all RouteMaps.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RouteMapInner> list(String resourceGroupName, String virtualHubName);

    /**
     * Retrieves the details of all RouteMaps.
     * 
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RouteMapInner> list(String resourceGroupName, String virtualHubName, Context context);
}
