// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The effective route configured on the virtual hub or specified resource.
 */
@Fluent
public final class VirtualHubEffectiveRoute {
    /*
     * The list of address prefixes.
     */
    @JsonProperty(value = "addressPrefixes")
    private List<String> addressPrefixes;

    /*
     * The list of next hops.
     */
    @JsonProperty(value = "nextHops")
    private List<String> nextHops;

    /*
     * The type of the next hop.
     */
    @JsonProperty(value = "nextHopType")
    private String nextHopType;

    /*
     * The ASPath of this route.
     */
    @JsonProperty(value = "asPath")
    private String asPath;

    /*
     * The origin of this route.
     */
    @JsonProperty(value = "routeOrigin")
    private String routeOrigin;

    /**
     * Creates an instance of VirtualHubEffectiveRoute class.
     */
    public VirtualHubEffectiveRoute() {
    }

    /**
     * Get the addressPrefixes property: The list of address prefixes.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: The list of address prefixes.
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the VirtualHubEffectiveRoute object itself.
     */
    public VirtualHubEffectiveRoute withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Get the nextHops property: The list of next hops.
     * 
     * @return the nextHops value.
     */
    public List<String> nextHops() {
        return this.nextHops;
    }

    /**
     * Set the nextHops property: The list of next hops.
     * 
     * @param nextHops the nextHops value to set.
     * @return the VirtualHubEffectiveRoute object itself.
     */
    public VirtualHubEffectiveRoute withNextHops(List<String> nextHops) {
        this.nextHops = nextHops;
        return this;
    }

    /**
     * Get the nextHopType property: The type of the next hop.
     * 
     * @return the nextHopType value.
     */
    public String nextHopType() {
        return this.nextHopType;
    }

    /**
     * Set the nextHopType property: The type of the next hop.
     * 
     * @param nextHopType the nextHopType value to set.
     * @return the VirtualHubEffectiveRoute object itself.
     */
    public VirtualHubEffectiveRoute withNextHopType(String nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    /**
     * Get the asPath property: The ASPath of this route.
     * 
     * @return the asPath value.
     */
    public String asPath() {
        return this.asPath;
    }

    /**
     * Set the asPath property: The ASPath of this route.
     * 
     * @param asPath the asPath value to set.
     * @return the VirtualHubEffectiveRoute object itself.
     */
    public VirtualHubEffectiveRoute withAsPath(String asPath) {
        this.asPath = asPath;
        return this;
    }

    /**
     * Get the routeOrigin property: The origin of this route.
     * 
     * @return the routeOrigin value.
     */
    public String routeOrigin() {
        return this.routeOrigin;
    }

    /**
     * Set the routeOrigin property: The origin of this route.
     * 
     * @param routeOrigin the routeOrigin value to set.
     * @return the VirtualHubEffectiveRoute object itself.
     */
    public VirtualHubEffectiveRoute withRouteOrigin(String routeOrigin) {
        this.routeOrigin = routeOrigin;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
