// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters that define the retention policy for flow log.
 */
@Fluent
public final class RetentionPolicyParameters {
    /*
     * Number of days to retain flow log records.
     */
    @JsonProperty(value = "days")
    private Integer days;

    /*
     * Flag to enable/disable retention.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /**
     * Creates an instance of RetentionPolicyParameters class.
     */
    public RetentionPolicyParameters() {
    }

    /**
     * Get the days property: Number of days to retain flow log records.
     * 
     * @return the days value.
     */
    public Integer days() {
        return this.days;
    }

    /**
     * Set the days property: Number of days to retain flow log records.
     * 
     * @param days the days value to set.
     * @return the RetentionPolicyParameters object itself.
     */
    public RetentionPolicyParameters withDays(Integer days) {
        this.days = days;
        return this;
    }

    /**
     * Get the enabled property: Flag to enable/disable retention.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Flag to enable/disable retention.
     * 
     * @param enabled the enabled value to set.
     * @return the RetentionPolicyParameters object itself.
     */
    public RetentionPolicyParameters withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
