// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Cross tenant scopes.
 */
@Immutable
public final class CrossTenantScopes {
    /*
     * Tenant ID.
     */
    @JsonProperty(value = "tenantId", access = JsonProperty.Access.WRITE_ONLY)
    private String tenantId;

    /*
     * List of management groups.
     */
    @JsonProperty(value = "managementGroups", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> managementGroups;

    /*
     * List of subscriptions.
     */
    @JsonProperty(value = "subscriptions", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> subscriptions;

    /**
     * Creates an instance of CrossTenantScopes class.
     */
    public CrossTenantScopes() {
    }

    /**
     * Get the tenantId property: Tenant ID.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the managementGroups property: List of management groups.
     * 
     * @return the managementGroups value.
     */
    public List<String> managementGroups() {
        return this.managementGroups;
    }

    /**
     * Get the subscriptions property: List of subscriptions.
     * 
     * @return the subscriptions value.
     */
    public List<String> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
