// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayPolicyGroupProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Parameters for VirtualNetworkGatewayPolicyGroup.
 */
@Fluent
public final class VirtualNetworkGatewayPolicyGroup extends SubResource {
    /*
     * Properties of tVirtualNetworkGatewayPolicyGroup.
     */
    @JsonProperty(value = "properties")
    private VirtualNetworkGatewayPolicyGroupProperties innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Creates an instance of VirtualNetworkGatewayPolicyGroup class.
     */
    public VirtualNetworkGatewayPolicyGroup() {
    }

    /**
     * Get the innerProperties property: Properties of tVirtualNetworkGatewayPolicyGroup.
     * 
     * @return the innerProperties value.
     */
    private VirtualNetworkGatewayPolicyGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @param name the name value to set.
     * @return the VirtualNetworkGatewayPolicyGroup object itself.
     */
    public VirtualNetworkGatewayPolicyGroup withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VirtualNetworkGatewayPolicyGroup withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the isDefault property: Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().isDefault();
    }

    /**
     * Set the isDefault property: Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not.
     * 
     * @param isDefault the isDefault value to set.
     * @return the VirtualNetworkGatewayPolicyGroup object itself.
     */
    public VirtualNetworkGatewayPolicyGroup withIsDefault(Boolean isDefault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPolicyGroupProperties();
        }
        this.innerProperties().withIsDefault(isDefault);
        return this;
    }

    /**
     * Get the priority property: Priority for VirtualNetworkGatewayPolicyGroup.
     * 
     * @return the priority value.
     */
    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    /**
     * Set the priority property: Priority for VirtualNetworkGatewayPolicyGroup.
     * 
     * @param priority the priority value to set.
     * @return the VirtualNetworkGatewayPolicyGroup object itself.
     */
    public VirtualNetworkGatewayPolicyGroup withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPolicyGroupProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    /**
     * Get the policyMembers property: Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     * 
     * @return the policyMembers value.
     */
    public List<VirtualNetworkGatewayPolicyGroupMember> policyMembers() {
        return this.innerProperties() == null ? null : this.innerProperties().policyMembers();
    }

    /**
     * Set the policyMembers property: Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
     * 
     * @param policyMembers the policyMembers value to set.
     * @return the VirtualNetworkGatewayPolicyGroup object itself.
     */
    public VirtualNetworkGatewayPolicyGroup
        withPolicyMembers(List<VirtualNetworkGatewayPolicyGroupMember> policyMembers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualNetworkGatewayPolicyGroupProperties();
        }
        this.innerProperties().withPolicyMembers(policyMembers);
        return this;
    }

    /**
     * Get the vngClientConnectionConfigurations property: List of references to vngClientConnectionConfigurations.
     * 
     * @return the vngClientConnectionConfigurations value.
     */
    public List<SubResource> vngClientConnectionConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().vngClientConnectionConfigurations();
    }

    /**
     * Get the provisioningState property: The provisioning state of the VirtualNetworkGatewayPolicyGroup resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
