// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The request for a migrateToIpBased API.
 */
@Fluent
public final class MigrateLoadBalancerToIpBasedRequest {
    /*
     * A list of pool names that should be migrated from Nic based to IP based pool
     */
    @JsonProperty(value = "pools")
    private List<String> pools;

    /**
     * Creates an instance of MigrateLoadBalancerToIpBasedRequest class.
     */
    public MigrateLoadBalancerToIpBasedRequest() {
    }

    /**
     * Get the pools property: A list of pool names that should be migrated from Nic based to IP based pool.
     * 
     * @return the pools value.
     */
    public List<String> pools() {
        return this.pools;
    }

    /**
     * Set the pools property: A list of pool names that should be migrated from Nic based to IP based pool.
     * 
     * @param pools the pools value to set.
     * @return the MigrateLoadBalancerToIpBasedRequest object itself.
     */
    public MigrateLoadBalancerToIpBasedRequest withPools(List<String> pools) {
        this.pools = pools;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
