// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * name and value of HTTP/S header to insert.
 */
@Fluent
public final class FirewallPolicyHttpHeaderToInsert {
    /*
     * Contains the name of the header
     */
    @JsonProperty(value = "headerName")
    private String headerName;

    /*
     * Contains the value of the header
     */
    @JsonProperty(value = "headerValue")
    private String headerValue;

    /**
     * Creates an instance of FirewallPolicyHttpHeaderToInsert class.
     */
    public FirewallPolicyHttpHeaderToInsert() {
    }

    /**
     * Get the headerName property: Contains the name of the header.
     * 
     * @return the headerName value.
     */
    public String headerName() {
        return this.headerName;
    }

    /**
     * Set the headerName property: Contains the name of the header.
     * 
     * @param headerName the headerName value to set.
     * @return the FirewallPolicyHttpHeaderToInsert object itself.
     */
    public FirewallPolicyHttpHeaderToInsert withHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    /**
     * Get the headerValue property: Contains the value of the header.
     * 
     * @return the headerValue value.
     */
    public String headerValue() {
        return this.headerValue;
    }

    /**
     * Set the headerValue property: Contains the value of the header.
     * 
     * @param headerValue the headerValue value to set.
     * @return the FirewallPolicyHttpHeaderToInsert object itself.
     */
    public FirewallPolicyHttpHeaderToInsert withHeaderValue(String headerValue) {
        this.headerValue = headerValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
