// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Properties of VngClientConnectionConfiguration.
 */
@Fluent
public final class VngClientConnectionConfigurationProperties {
    /*
     * The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JsonProperty(value = "vpnClientAddressPool", required = true)
    private AddressSpace vpnClientAddressPool;

    /*
     * List of references to virtualNetworkGatewayPolicyGroups
     */
    @JsonProperty(value = "virtualNetworkGatewayPolicyGroups", required = true)
    private List<SubResource> virtualNetworkGatewayPolicyGroups;

    /*
     * The provisioning state of the VngClientConnectionConfiguration resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of VngClientConnectionConfigurationProperties class.
     */
    public VngClientConnectionConfigurationProperties() {
    }

    /**
     * Get the vpnClientAddressPool property: The reference to the address space resource which represents Address
     * space for P2S VpnClient.
     * 
     * @return the vpnClientAddressPool value.
     */
    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    /**
     * Set the vpnClientAddressPool property: The reference to the address space resource which represents Address
     * space for P2S VpnClient.
     * 
     * @param vpnClientAddressPool the vpnClientAddressPool value to set.
     * @return the VngClientConnectionConfigurationProperties object itself.
     */
    public VngClientConnectionConfigurationProperties withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    /**
     * Get the virtualNetworkGatewayPolicyGroups property: List of references to virtualNetworkGatewayPolicyGroups.
     * 
     * @return the virtualNetworkGatewayPolicyGroups value.
     */
    public List<SubResource> virtualNetworkGatewayPolicyGroups() {
        return this.virtualNetworkGatewayPolicyGroups;
    }

    /**
     * Set the virtualNetworkGatewayPolicyGroups property: List of references to virtualNetworkGatewayPolicyGroups.
     * 
     * @param virtualNetworkGatewayPolicyGroups the virtualNetworkGatewayPolicyGroups value to set.
     * @return the VngClientConnectionConfigurationProperties object itself.
     */
    public VngClientConnectionConfigurationProperties
        withVirtualNetworkGatewayPolicyGroups(List<SubResource> virtualNetworkGatewayPolicyGroups) {
        this.virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the VngClientConnectionConfiguration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vpnClientAddressPool() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property vpnClientAddressPool in model VngClientConnectionConfigurationProperties"));
        } else {
            vpnClientAddressPool().validate();
        }
        if (virtualNetworkGatewayPolicyGroups() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property virtualNetworkGatewayPolicyGroups in model VngClientConnectionConfigurationProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VngClientConnectionConfigurationProperties.class);
}
