// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.models.NetworkVirtualApplianceSkuInstances;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Available NetworkVirtualApplianceSkus
 * 
 * Definition of the NetworkVirtualApplianceSkus resource.
 */
@Fluent
public final class NetworkVirtualApplianceSkuInner extends Resource {
    /*
     * Network Virtual Appliance Sku Properties
     * 
     * NetworkVirtualApplianceSku properties.
     */
    @JsonProperty(value = "properties")
    private NetworkVirtualApplianceSkuPropertiesFormat innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Creates an instance of NetworkVirtualApplianceSkuInner class.
     */
    public NetworkVirtualApplianceSkuInner() {
    }

    /**
     * Get the innerProperties property: Network Virtual Appliance Sku Properties
     * 
     * NetworkVirtualApplianceSku properties.
     * 
     * @return the innerProperties value.
     */
    private NetworkVirtualApplianceSkuPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the NetworkVirtualApplianceSkuInner object itself.
     */
    public NetworkVirtualApplianceSkuInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkVirtualApplianceSkuInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkVirtualApplianceSkuInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the vendor property: Network Virtual Appliance Sku vendor.
     * 
     * @return the vendor value.
     */
    public String vendor() {
        return this.innerProperties() == null ? null : this.innerProperties().vendor();
    }

    /**
     * Get the availableVersions property: Available Network Virtual Appliance versions.
     * 
     * @return the availableVersions value.
     */
    public List<String> availableVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().availableVersions();
    }

    /**
     * Get the availableScaleUnits property: The list of scale units available.
     * 
     * @return the availableScaleUnits value.
     */
    public List<NetworkVirtualApplianceSkuInstances> availableScaleUnits() {
        return this.innerProperties() == null ? null : this.innerProperties().availableScaleUnits();
    }

    /**
     * Set the availableScaleUnits property: The list of scale units available.
     * 
     * @param availableScaleUnits the availableScaleUnits value to set.
     * @return the NetworkVirtualApplianceSkuInner object itself.
     */
    public NetworkVirtualApplianceSkuInner
        withAvailableScaleUnits(List<NetworkVirtualApplianceSkuInstances> availableScaleUnits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualApplianceSkuPropertiesFormat();
        }
        this.innerProperties().withAvailableScaleUnits(availableScaleUnits);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
