// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.GatewayLoadBalancerTunnelInterface;
import com.azure.resourcemanager.network.models.LoadBalancerBackendAddress;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SyncMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Pool of backend IP addresses.
 */
@Fluent
public final class BackendAddressPoolInner extends SubResource {
    /*
     * Properties of load balancer backend address pool.
     */
    @JsonProperty(value = "properties")
    private BackendAddressPoolPropertiesFormat innerProperties;

    /*
     * The name of the resource that is unique within the set of backend address pools used by the load balancer. This
     * name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Type of the resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Creates an instance of BackendAddressPoolInner class.
     */
    public BackendAddressPoolInner() {
    }

    /**
     * Get the innerProperties property: Properties of load balancer backend address pool.
     * 
     * @return the innerProperties value.
     */
    private BackendAddressPoolPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within the set of backend address pools used by
     * the load balancer. This name can be used to access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within the set of backend address pools used by
     * the load balancer. This name can be used to access the resource.
     * 
     * @param name the name value to set.
     * @return the BackendAddressPoolInner object itself.
     */
    public BackendAddressPoolInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BackendAddressPoolInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the location property: The location of the backend address pool.
     * 
     * @return the location value.
     */
    public String location() {
        return this.innerProperties() == null ? null : this.innerProperties().location();
    }

    /**
     * Set the location property: The location of the backend address pool.
     * 
     * @param location the location value to set.
     * @return the BackendAddressPoolInner object itself.
     */
    public BackendAddressPoolInner withLocation(String location) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withLocation(location);
        return this;
    }

    /**
     * Get the tunnelInterfaces property: An array of gateway load balancer tunnel interfaces.
     * 
     * @return the tunnelInterfaces value.
     */
    public List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().tunnelInterfaces();
    }

    /**
     * Set the tunnelInterfaces property: An array of gateway load balancer tunnel interfaces.
     * 
     * @param tunnelInterfaces the tunnelInterfaces value to set.
     * @return the BackendAddressPoolInner object itself.
     */
    public BackendAddressPoolInner withTunnelInterfaces(List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withTunnelInterfaces(tunnelInterfaces);
        return this;
    }

    /**
     * Get the loadBalancerBackendAddresses property: An array of backend addresses.
     * 
     * @return the loadBalancerBackendAddresses value.
     */
    public List<LoadBalancerBackendAddress> loadBalancerBackendAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerBackendAddresses();
    }

    /**
     * Set the loadBalancerBackendAddresses property: An array of backend addresses.
     * 
     * @param loadBalancerBackendAddresses the loadBalancerBackendAddresses value to set.
     * @return the BackendAddressPoolInner object itself.
     */
    public BackendAddressPoolInner
        withLoadBalancerBackendAddresses(List<LoadBalancerBackendAddress> loadBalancerBackendAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withLoadBalancerBackendAddresses(loadBalancerBackendAddresses);
        return this;
    }

    /**
     * Get the backendIpConfigurations property: An array of references to IP addresses defined in network interfaces.
     * 
     * @return the backendIpConfigurations value.
     */
    public List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().backendIpConfigurations();
    }

    /**
     * Get the loadBalancingRules property: An array of references to load balancing rules that use this backend
     * address pool.
     * 
     * @return the loadBalancingRules value.
     */
    public List<SubResource> loadBalancingRules() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingRules();
    }

    /**
     * Get the outboundRule property: A reference to an outbound rule that uses this backend address pool.
     * 
     * @return the outboundRule value.
     */
    public SubResource outboundRule() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundRule();
    }

    /**
     * Get the outboundRules property: An array of references to outbound rules that use this backend address pool.
     * 
     * @return the outboundRules value.
     */
    public List<SubResource> outboundRules() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundRules();
    }

    /**
     * Get the inboundNatRules property: An array of references to inbound NAT rules that use this backend address
     * pool.
     * 
     * @return the inboundNatRules value.
     */
    public List<SubResource> inboundNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatRules();
    }

    /**
     * Get the provisioningState property: The provisioning state of the backend address pool resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the drainPeriodInSeconds property: Amount of seconds Load Balancer waits for before sending RESET to client
     * and backend address.
     * 
     * @return the drainPeriodInSeconds value.
     */
    public Integer drainPeriodInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().drainPeriodInSeconds();
    }

    /**
     * Set the drainPeriodInSeconds property: Amount of seconds Load Balancer waits for before sending RESET to client
     * and backend address.
     * 
     * @param drainPeriodInSeconds the drainPeriodInSeconds value to set.
     * @return the BackendAddressPoolInner object itself.
     */
    public BackendAddressPoolInner withDrainPeriodInSeconds(Integer drainPeriodInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withDrainPeriodInSeconds(drainPeriodInSeconds);
        return this;
    }

    /**
     * Get the virtualNetwork property: A reference to a virtual network.
     * 
     * @return the virtualNetwork value.
     */
    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    /**
     * Set the virtualNetwork property: A reference to a virtual network.
     * 
     * @param virtualNetwork the virtualNetwork value to set.
     * @return the BackendAddressPoolInner object itself.
     */
    public BackendAddressPoolInner withVirtualNetwork(SubResource virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    /**
     * Get the syncMode property: Backend address synchronous mode for the backend pool.
     * 
     * @return the syncMode value.
     */
    public SyncMode syncMode() {
        return this.innerProperties() == null ? null : this.innerProperties().syncMode();
    }

    /**
     * Set the syncMode property: Backend address synchronous mode for the backend pool.
     * 
     * @param syncMode the syncMode value to set.
     * @return the BackendAddressPoolInner object itself.
     */
    public BackendAddressPoolInner withSyncMode(SyncMode syncMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withSyncMode(syncMode);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
