// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network. */
@Fluent
public final class VirtualNetworkPeeringListResult {
    /*
     * The peerings in a virtual network.
     */
    @JsonProperty(value = "value")
    private List<VirtualNetworkPeeringInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of VirtualNetworkPeeringListResult class. */
    public VirtualNetworkPeeringListResult() {
    }

    /**
     * Get the value property: The peerings in a virtual network.
     *
     * @return the value value.
     */
    public List<VirtualNetworkPeeringInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The peerings in a virtual network.
     *
     * @param value the value value to set.
     * @return the VirtualNetworkPeeringListResult object itself.
     */
    public VirtualNetworkPeeringListResult withValue(List<VirtualNetworkPeeringInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the VirtualNetworkPeeringListResult object itself.
     */
    public VirtualNetworkPeeringListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
