// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes a column to sort. */
@Fluent
public final class OrderBy {
    /*
     * Describes the actual column name to sort by
     */
    @JsonProperty(value = "field")
    private String field;

    /*
     * Describes if results should be in ascending/descending order
     */
    @JsonProperty(value = "order")
    private FirewallPolicyIdpsQuerySortOrder order;

    /** Creates an instance of OrderBy class. */
    public OrderBy() {
    }

    /**
     * Get the field property: Describes the actual column name to sort by.
     *
     * @return the field value.
     */
    public String field() {
        return this.field;
    }

    /**
     * Set the field property: Describes the actual column name to sort by.
     *
     * @param field the field value to set.
     * @return the OrderBy object itself.
     */
    public OrderBy withField(String field) {
        this.field = field;
        return this;
    }

    /**
     * Get the order property: Describes if results should be in ascending/descending order.
     *
     * @return the order value.
     */
    public FirewallPolicyIdpsQuerySortOrder order() {
        return this.order;
    }

    /**
     * Set the order property: Describes if results should be in ascending/descending order.
     *
     * @param order the order value to set.
     * @return the OrderBy object itself.
     */
    public OrderBy withOrder(FirewallPolicyIdpsQuerySortOrder order) {
        this.order = order;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
