// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response for list ip configurations API service call. */
@Fluent
public final class NetworkInterfaceIpConfigurationListResult {
    /*
     * A list of ip configurations.
     */
    @JsonProperty(value = "value")
    private List<NetworkInterfaceIpConfigurationInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /** Creates an instance of NetworkInterfaceIpConfigurationListResult class. */
    public NetworkInterfaceIpConfigurationListResult() {
    }

    /**
     * Get the value property: A list of ip configurations.
     *
     * @return the value value.
     */
    public List<NetworkInterfaceIpConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of ip configurations.
     *
     * @param value the value value to set.
     * @return the NetworkInterfaceIpConfigurationListResult object itself.
     */
    public NetworkInterfaceIpConfigurationListResult withValue(List<NetworkInterfaceIpConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
