// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of the web application firewall rule set. */
@Fluent
public final class ApplicationGatewayFirewallManifestRuleSet {
    /*
     * The type of the web application firewall rule set.
     */
    @JsonProperty(value = "ruleSetType", required = true)
    private String ruleSetType;

    /*
     * The version of the web application firewall rule set type.
     */
    @JsonProperty(value = "ruleSetVersion", required = true)
    private String ruleSetVersion;

    /*
     * The rule set status
     */
    @JsonProperty(value = "status")
    private ApplicationGatewayRuleSetStatusOptions status;

    /*
     * Tier of an application gateway that support the rule set.
     */
    @JsonProperty(value = "tiers")
    private List<ApplicationGatewayTierTypes> tiers;

    /*
     * The rule groups of the web application firewall rule set.
     */
    @JsonProperty(value = "ruleGroups", required = true)
    private List<ApplicationGatewayFirewallRuleGroup> ruleGroups;

    /** Creates an instance of ApplicationGatewayFirewallManifestRuleSet class. */
    public ApplicationGatewayFirewallManifestRuleSet() {
    }

    /**
     * Get the ruleSetType property: The type of the web application firewall rule set.
     *
     * @return the ruleSetType value.
     */
    public String ruleSetType() {
        return this.ruleSetType;
    }

    /**
     * Set the ruleSetType property: The type of the web application firewall rule set.
     *
     * @param ruleSetType the ruleSetType value to set.
     * @return the ApplicationGatewayFirewallManifestRuleSet object itself.
     */
    public ApplicationGatewayFirewallManifestRuleSet withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    /**
     * Get the ruleSetVersion property: The version of the web application firewall rule set type.
     *
     * @return the ruleSetVersion value.
     */
    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    /**
     * Set the ruleSetVersion property: The version of the web application firewall rule set type.
     *
     * @param ruleSetVersion the ruleSetVersion value to set.
     * @return the ApplicationGatewayFirewallManifestRuleSet object itself.
     */
    public ApplicationGatewayFirewallManifestRuleSet withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    /**
     * Get the status property: The rule set status.
     *
     * @return the status value.
     */
    public ApplicationGatewayRuleSetStatusOptions status() {
        return this.status;
    }

    /**
     * Set the status property: The rule set status.
     *
     * @param status the status value to set.
     * @return the ApplicationGatewayFirewallManifestRuleSet object itself.
     */
    public ApplicationGatewayFirewallManifestRuleSet withStatus(ApplicationGatewayRuleSetStatusOptions status) {
        this.status = status;
        return this;
    }

    /**
     * Get the tiers property: Tier of an application gateway that support the rule set.
     *
     * @return the tiers value.
     */
    public List<ApplicationGatewayTierTypes> tiers() {
        return this.tiers;
    }

    /**
     * Set the tiers property: Tier of an application gateway that support the rule set.
     *
     * @param tiers the tiers value to set.
     * @return the ApplicationGatewayFirewallManifestRuleSet object itself.
     */
    public ApplicationGatewayFirewallManifestRuleSet withTiers(List<ApplicationGatewayTierTypes> tiers) {
        this.tiers = tiers;
        return this;
    }

    /**
     * Get the ruleGroups property: The rule groups of the web application firewall rule set.
     *
     * @return the ruleGroups value.
     */
    public List<ApplicationGatewayFirewallRuleGroup> ruleGroups() {
        return this.ruleGroups;
    }

    /**
     * Set the ruleGroups property: The rule groups of the web application firewall rule set.
     *
     * @param ruleGroups the ruleGroups value to set.
     * @return the ApplicationGatewayFirewallManifestRuleSet object itself.
     */
    public ApplicationGatewayFirewallManifestRuleSet withRuleGroups(
        List<ApplicationGatewayFirewallRuleGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleSetType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property ruleSetType in model ApplicationGatewayFirewallManifestRuleSet"));
        }
        if (ruleSetVersion() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property ruleSetVersion in model ApplicationGatewayFirewallManifestRuleSet"));
        }
        if (ruleGroups() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property ruleGroups in model ApplicationGatewayFirewallManifestRuleSet"));
        } else {
            ruleGroups().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApplicationGatewayFirewallManifestRuleSet.class);
}
