// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Trusted client certificates properties of an application gateway. */
@Fluent
public final class ApplicationGatewayTrustedClientCertificatePropertiesFormat {
    /*
     * Certificate public data.
     */
    @JsonProperty(value = "data")
    private String data;

    /*
     * Validated certificate data.
     */
    @JsonProperty(value = "validatedCertData", access = JsonProperty.Access.WRITE_ONLY)
    private String validatedCertData;

    /*
     * Distinguished name of client certificate issuer.
     */
    @JsonProperty(value = "clientCertIssuerDN", access = JsonProperty.Access.WRITE_ONLY)
    private String clientCertIssuerDN;

    /*
     * The provisioning state of the trusted client certificate resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /** Creates an instance of ApplicationGatewayTrustedClientCertificatePropertiesFormat class. */
    public ApplicationGatewayTrustedClientCertificatePropertiesFormat() {
    }

    /**
     * Get the data property: Certificate public data.
     *
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: Certificate public data.
     *
     * @param data the data value to set.
     * @return the ApplicationGatewayTrustedClientCertificatePropertiesFormat object itself.
     */
    public ApplicationGatewayTrustedClientCertificatePropertiesFormat withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the validatedCertData property: Validated certificate data.
     *
     * @return the validatedCertData value.
     */
    public String validatedCertData() {
        return this.validatedCertData;
    }

    /**
     * Get the clientCertIssuerDN property: Distinguished name of client certificate issuer.
     *
     * @return the clientCertIssuerDN value.
     */
    public String clientCertIssuerDN() {
        return this.clientCertIssuerDN;
    }

    /**
     * Get the provisioningState property: The provisioning state of the trusted client certificate resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
