// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerConnectionInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * ManagementGroupNetworkManagerConnectionsClient.
 */
public interface ManagementGroupNetworkManagerConnectionsClient extends InnerSupportsDelete<Void> {
    /**
     * Create a network manager connection on this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @param parameters Network manager connection to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Manager Connection resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkManagerConnectionInner>> createOrUpdateWithResponseAsync(
        String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters);

    /**
     * Create a network manager connection on this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @param parameters Network manager connection to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Manager Connection resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkManagerConnectionInner> createOrUpdateAsync(
        String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters);

    /**
     * Create a network manager connection on this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @param parameters Network manager connection to be created/updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Manager Connection resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkManagerConnectionInner> createOrUpdateWithResponse(
        String managementGroupId,
        String networkManagerConnectionName,
        NetworkManagerConnectionInner parameters,
        Context context);

    /**
     * Create a network manager connection on this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @param parameters Network manager connection to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Manager Connection resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkManagerConnectionInner createOrUpdate(
        String managementGroupId, String networkManagerConnectionName, NetworkManagerConnectionInner parameters);

    /**
     * Get a specified connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specified connection created by this management group along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkManagerConnectionInner>> getWithResponseAsync(
        String managementGroupId, String networkManagerConnectionName);

    /**
     * Get a specified connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specified connection created by this management group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkManagerConnectionInner> getAsync(String managementGroupId, String networkManagerConnectionName);

    /**
     * Get a specified connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specified connection created by this management group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkManagerConnectionInner> getWithResponse(
        String managementGroupId, String networkManagerConnectionName, Context context);

    /**
     * Get a specified connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specified connection created by this management group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkManagerConnectionInner get(String managementGroupId, String networkManagerConnectionName);

    /**
     * Delete specified pending connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String managementGroupId, String networkManagerConnectionName);

    /**
     * Delete specified pending connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String managementGroupId, String networkManagerConnectionName);

    /**
     * Delete specified pending connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String managementGroupId, String networkManagerConnectionName, Context context);

    /**
     * Delete specified pending connection created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param networkManagerConnectionName Name for the network manager connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String managementGroupId, String networkManagerConnectionName);

    /**
     * List all network manager connections created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     *     server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skipToken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of network manager connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkManagerConnectionInner> listAsync(String managementGroupId, Integer top, String skipToken);

    /**
     * List all network manager connections created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of network manager connections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkManagerConnectionInner> listAsync(String managementGroupId);

    /**
     * List all network manager connections created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of network manager connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkManagerConnectionInner> list(String managementGroupId);

    /**
     * List all network manager connections created by this management group.
     *
     * @param managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     *     server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     *     contains a nextLink element, the value of the nextLink element will include a skipToken parameter that
     *     specifies a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of network manager connections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkManagerConnectionInner> list(
        String managementGroupId, Integer top, String skipToken, Context context);
}
